/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.part.SignalGate;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;

public class SRLatch
extends SignalGate {
    protected ISignalReceiver outputR = ISignalReceiver.NOP;
    @Sync
    public int inS;
    @Sync
    public int inR;

    public SRLatch() {
        super(4);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 0);
        this.setPort(1, pos, Direction.SOUTH, 0);
        this.setPort(2, pos, Direction.EAST, 0);
        this.setPort(3, pos, Direction.WEST, 0);
    }

    @Override
    public void setHandler(int port, Object handler) {
        if (port == 0) {
            super.setHandler(port, handler);
        } else if (handler instanceof ISignalReceiver) {
            this.outputR = (ISignalReceiver)handler;
            this.outputR.updateInput(~this.state);
        } else {
            this.outputR = ISignalReceiver.NOP;
        }
    }

    public ISignalReceiver getHandler(int port) {
        return port == 2 ? (v, r) -> {
            this.inR = v;
            if (this.inR != this.inR) {
                this.update();
            }
        } : (port == 3 ? (v, r) -> {
            this.inS = v;
            if (this.inS != this.inS) {
                this.update();
            }
        } : null);
    }

    @Override
    public boolean isMaster(int channel) {
        return channel < 2;
    }

    public boolean evaluate() {
        this.active = false;
        return this.host != null && (this.state = (this.state | this.inS) & ~this.inR) != this.state;
    }

    @Override
    public void latchOut() {
        this.output.updateInput(this.state);
        this.outputR.updateInput(~this.state);
    }

    public Item item() {
        return Content.sr_latch;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.sr_latch", this.state, ~this.state, this.inR, this.inS};
    }
}

