/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.port.IEnergyAccess;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.ISlowTickable;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.part.MultiBlock;
import net.minecraft.item.Item;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class SolarCell
extends MultiBlock<SolarCell>
implements ISlowTickable {
    public static float INV_DAY_LENGHT;
    IEnergyAccess energy = IEnergyAccess.NOP;
    int power = -1;
    boolean active;
    boolean fixTime;
    public static final ResourceLocation MODEL;

    public SolarCell(int pos) {
        super(pos);
    }

    public Item item() {
        return Content.solarcell;
    }

    @Override
    protected void onBoundsChange() {
        this.power = -1;
    }

    public Object getHandler(int port) {
        return null;
    }

    public void setHandler(int port, Object handler) {
        this.energy = IEnergyAccess.of((Object)handler);
    }

    public boolean isMaster(int port) {
        return true;
    }

    public SolarCell setHost(IGridHost host) {
        super.setHost(host);
        if (host == null || this.active) {
            return this;
        }
        DimensionType dt = host.world().func_230315_m_();
        if (!dt.func_218272_d()) {
            return this;
        }
        this.fixTime = dt.func_241514_p_();
        this.active = true;
        GateUpdater.GATE_UPDATER.add((ISlowTickable)this);
        return this;
    }

    public boolean tick8() {
        int p;
        if (this.host == null) {
            this.active = false;
            return false;
        }
        if (this.power < 0 || (GateUpdater.TICK & 0x38) == 0) {
            this.updatePower();
        }
        if ((p = this.power()) > 0) {
            this.energy.transferEnergy(p, false);
        }
        return true;
    }

    private int power() {
        return this.fixTime ? this.power : SolarCell.sunPower(this.power, (int)((this.host.world().func_241851_ab() + 6000L) % 24000L) - 12000);
    }

    private void updatePower() {
        World world = this.host.world();
        long b = this.host.bounds();
        b = b >> 4 & 0xFFF0FFF0FFF0FFFL | b >> 8 & 0xFF00FF00FF00FFL | b >> 12 & 0xF000F000F000FL;
        this.power = Long.bitCount(this.bounds & (b ^ 0xFFFFFFFFFFFFFFFFL)) * (Integer)Main.SERVER_CFG.solar_power.get() * world.func_226658_a_(LightType.SKY, this.host.pos().func_177984_a()) / 15;
        if (this.fixTime) {
            float t = world.func_242415_f(1.0f);
            this.power = SolarCell.sunPower(this.power, (t > 0.5f ? t - 1.0f : t) * 24000.0f);
        }
    }

    private static int sunPower(int base, float dt) {
        return Math.round((1.0f - (dt *= INV_DAY_LENGHT) * dt) * (float)base);
    }

    @Override
    protected ActionResultType createPort(IGridItem item, short port, boolean client) {
        if (item != Content.power_cable) {
            return ActionResultType.PASS;
        }
        if (client) {
            return ActionResultType.CONSUME;
        }
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        if (this.ports.length == 0) {
            this.ports = new short[1];
        }
        this.ports[0] = (short)(port | 0x1000);
        host.addPart((GridPart)this);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected SolarCell splitOff(long splitBounds, long thisBounds) {
        return new SolarCell(-1);
    }

    @Override
    protected short[] merge(SolarCell other) {
        return this.ports.length == 0 && other.ports.length != 0 ? other.ports : this.ports;
    }

    @Override
    protected ResourceLocation model() {
        return MODEL;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.solar", Math.max(this.power(), 0), this.energy.transferEnergy(Integer.MAX_VALUE, true)};
    }

    static {
        MODEL = Main.rl("part/solarcell");
    }
}

