/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.IDynamicPart;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.render.GridModels;
import cd4017be.lib.util.Orientation;
import cd4017be.math.Linalg;
import cd4017be.math.MCConv;
import cd4017be.math.Orient;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.part.ExtendablePart;
import cd4017be.rs_ctr2.part.Switch;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SwitchArray
extends ExtendablePart
implements IDynamicPart {
    ISignalReceiver out = ISignalReceiver.NOP;
    @Sync(to=7)
    public byte state;

    public SwitchArray() {
        super(1);
    }

    @Override
    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setPort(0, pos + (pos >> 6 & 3), Direction.NORTH, 0);
    }

    public Item item() {
        return Content.switch_array;
    }

    @Override
    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        ActionResultType ret = super.onInteract(player, hand, hit, pos);
        if (ret != ActionResultType.PASS || player.func_213453_ef()) {
            return ret;
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        Vector3d vec = hit.func_216347_e();
        float[] v = Linalg.dadd((int)3, (float[])MCConv.blockRelVecF((Vector3d)vec, (BlockPos)hit.func_216350_a()), (float)-0.5f);
        Orient.orient((int)this.orient.inv().o, (float[])v);
        pos = ((this.pos << 1) + (this.pos >> 5) & 6) + 1 - (int)(v[0] * 8.0f + 4.0f);
        this.state = (byte)(this.state ^ 1 << pos);
        this.out.updateInput(this.state & 0xFF);
        this.host.updateDisplay();
        player.field_70170_p.func_184148_a(null, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (SoundEvent)Content.SWITCH_FLIp, SoundCategory.BLOCKS, 1.0f, 0.5f);
        return ActionResultType.SUCCESS;
    }

    public Object getHandler(int port) {
        return null;
    }

    public void setHandler(int port, Object handler) {
        this.out = ISignalReceiver.of((Object)handler);
        this.out.updateInput(this.state & 0xFF);
    }

    public boolean isMaster(int port) {
        return true;
    }

    public byte getLayer() {
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack ms, IRenderTypeBuffer rtb, int light, int overlay, float t, long opaque) {
        if ((this.bounds & (opaque ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return;
        }
        ms.func_227860_a_();
        this.transform(ms);
        ms.func_227861_a_(-0.0625, 0.0, 0.0);
        IVertexBuilder vb = rtb.getBuffer(RenderType.func_228639_c_());
        for (int i = this.pos >> 5 & 6 | 1; i >= 0; --i) {
            GridModels.draw((ResourceLocation)((this.state >> i & 1) != 0 ? Switch.ON : Switch.OFF), (MatrixStack.Entry)ms.func_227866_c_(), (IVertexBuilder)vb, (int)-1, (int)light, (int)overlay);
            ms.func_227861_a_(0.125, 0.0, 0.0);
        }
        ms.func_227865_b_();
    }

    public void readSync(PacketBuffer pkt) {
        this.state = pkt.readByte();
    }

    public void writeSync(PacketBuffer pkt, boolean init) {
        pkt.writeByte((int)this.state);
    }
}

