/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.IPortHolder;
import cd4017be.api.grid.Link;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.item.WirelessItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;

public abstract class Wireless
extends OrientedPart
implements IProbeInfo {
    private final WirelessItem item;
    @Sync
    public int link;

    public Wireless(WirelessItem item) {
        super(1);
        this.item = item;
    }

    public Item item() {
        return this.item;
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, this.item.type);
    }

    public Object getHandler(int port) {
        return this;
    }

    public boolean isMaster(int port) {
        return false;
    }

    public GridPart setHost(IGridHost host) {
        if (host != null) {
            Link.load((IPortHolder)this, (int)1, (int)this.link);
        } else {
            Link.unload((IPortHolder)this, (int)1, (int)this.link);
        }
        return super.setHost(host);
    }

    public ItemStack asItemStack() {
        ItemStack stack = super.asItemStack();
        stack.func_196082_o().func_74768_a("link", this.link);
        return stack;
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        ItemStack stack = player.func_184614_ca();
        if (hand != null) {
            return ActionResultType.PASS;
        }
        if (!player.field_70170_p.field_72995_K && stack.func_77973_b() instanceof IGridItem) {
            IGridHost host = this.host;
            host.removePart((GridPart)this);
            host.removeIfEmpty();
            if (stack.func_77973_b() == this.item.pair && WirelessItem.hasLink(stack)) {
                stack.func_190918_g(1);
                ItemFluidUtil.dropStack((ItemStack)super.asItemStack(), (Entity)player);
            } else {
                ItemFluidUtil.dropStack((ItemStack)this.asItemStack(), (Entity)player);
            }
        }
        return ActionResultType.CONSUME;
    }
}

