/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.render;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.text.TooltipUtil;
import cd4017be.lib.util.VoxelShape4x4x4;
import cd4017be.rs_ctr2.item.SignalProbeItem;
import cd4017be.rs_ctr2.render.Printer;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class SignalProbeRenderer
extends ItemStackTileEntityRenderer {
    private static final Quaternion[] ROTATIONS = new Quaternion[6];
    private final VoxelShape4x4x4 bounds = new VoxelShape4x4x4();
    private final JitBakedModel model = new JitBakedModel(0);

    public static ResourceLocation baseModel(Item item) {
        ResourceLocation model = item.getRegistryName();
        return new ResourceLocation(model.func_110624_b(), "item/" + model.func_110623_a() + "_base");
    }

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transform, MatrixStack mat, IRenderTypeBuffer vb, int light, int overlay) {
        Minecraft mc = Minecraft.func_71410_x();
        mat.func_227861_a_(0.5, 0.5, 0.5);
        IBakedModel model = mc.func_209506_al().getModel(SignalProbeRenderer.baseModel(stack.func_77973_b()));
        mc.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, mat, vb, light, overlay, model);
        if (transform != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND && transform != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            return;
        }
        mat.func_227860_a_();
        mat.func_227861_a_(-0.1875, 0.4375, 0.032);
        mat.func_227862_a_(0.00390625f, -0.00390625f, 0.00390625f);
        Printer p = new Printer(vb, mat, 240).color(-256);
        mat.func_227865_b_();
        this.drawDisplay(stack.func_196082_o(), p, mat, vb, 240, overlay);
    }

    private void drawDisplay(CompoundNBT nbt, Printer pr, MatrixStack mat, IRenderTypeBuffer rtb, int light, int overlay) {
        int[] ports = SignalProbeItem.readPorts(nbt);
        if (ports == null) {
            pr.row(5).col(2).print(TooltipUtil.translate((String)"state.rs_ctr2.no_connection"));
            return;
        }
        mat.func_227860_a_();
        mat.func_227862_a_(1.0f, 1.0f, 0.5f);
        mat.func_227861_a_(-0.0625, 0.3125, 0.125);
        Minecraft mc = Minecraft.func_71410_x();
        mat.func_227863_a_(new Quaternion(mc.field_71439_g.field_70125_A, mc.field_71439_g.field_70177_z + 180.0f, 0.0f, true));
        pr.row(5).col(64).print(this.drawBlock(mat, mc, BlockPos.func_218283_e((long)nbt.func_74763_f("bp")), nbt.func_74771_c("gp"), rtb, light, overlay).func_200301_q(), 96);
        long b = this.bounds.grid;
        mat.func_227862_a_(0.03125f, 0.03125f, 0.03125f);
        FontRenderer fr = mc.field_71466_p;
        int n = 0;
        for (int i = 0; i < ports.length; ++i) {
            int port = ports[i];
            if (port == 0) continue;
            ++n;
            mat.func_227860_a_();
            mat.func_227861_a_((double)(port << 2 & 0x3C), (double)(port >> 2 & 0x3C), (double)(port >> 6 & 0x3C));
            int ax = Integer.numberOfTrailingZeros(~port & 0x111) >> 1;
            int p = IGridHost.posOfport((int)(port - 273));
            if (p >= 0 && ((b >> p & 1L) != 0L || IGridHost.posOfport((int)port) < 0)) {
                ax |= 1;
            }
            mat.func_227863_a_(ROTATIONS[ax % 6]);
            mat.func_227861_a_(0.0, 0.0, -0.5);
            String s = Integer.toString(i);
            fr.func_228079_a_(s, (float)(fr.func_78256_a(s) - 1) * -0.5f, -3.5f, port << 1 < 0 ? -128 : -1, false, mat.func_227866_c_().func_227870_a_(), rtb, false, 0, light);
            mat.func_227865_b_();
        }
        mat.func_227865_b_();
        pr.row(48).col(64).color(-1).print(TooltipUtil.format((String)"state.rs_ctr2.ports", (Object[])new Object[]{n}));
        pr.row(64);
        for (String s : SignalProbeItem.readInfo(nbt).split("\n")) {
            pr.col(2).print(s).nl();
        }
        if (!mc.field_71474_y.field_74330_P || !nbt.func_150297_b("ports", 12)) {
            return;
        }
        long[] arr = nbt.func_197645_o("ports");
        pr.nl().col(2).print(TooltipUtil.translate((String)"state.rs_ctr2.links"));
        long used = 0L;
        block7: for (int i = 0; i < arr.length; ++i) {
            String s;
            long x = arr[i];
            if (x == 0L) continue;
            boolean nl = true;
            switch ((int)(x >> 60) & 3) {
                case 0: {
                    s = TooltipUtil.format((String)"state.rs_ctr2.link0", (Object[])new Object[]{i, x >> 48 & 0xFFL});
                    used |= 1L << i;
                    break;
                }
                case 1: {
                    s = TooltipUtil.format((String)"state.rs_ctr2.link1", (Object[])new Object[]{i, (int)x, x >> 48 & 0xFFL});
                    used |= 1L << i;
                    break;
                }
                case 2: {
                    int j = (int)x >> 16 & 0xFF;
                    if (j > i || (used >> j & 1L) != 0L) continue block7;
                    s = TooltipUtil.format((String)"state.rs_ctr2.link2", (Object[])new Object[]{i, j});
                    break;
                }
                default: {
                    s = TooltipUtil.format((String)"state.rs_ctr2.link3", (Object[])new Object[]{i, (int)x});
                    if (pr.x >= 75) break;
                    pr.col(80);
                    nl = false;
                }
            }
            if (nl) {
                pr.nl().col(2);
            }
            pr.color(x << 1 < 0L ? -128 : -4144960).print(s);
        }
    }

    private ItemStack drawBlock(MatrixStack mat, Minecraft mc, BlockPos pos, byte gp, IRenderTypeBuffer rtb, int light, int overlay) {
        if (gp < 0) {
            mat.func_227862_a_(0.125f, 0.125f, 0.125f);
            mat.func_227861_a_(-0.5, -0.5, -0.5);
            BlockState state = mc.field_71441_e.func_180495_p(pos);
            mat.func_227860_a_();
            IModelData data = ModelDataManager.getModelData((World)mc.field_71441_e, (BlockPos)pos);
            if (data == null) {
                data = EmptyModelData.INSTANCE;
            }
            mc.func_175602_ab().renderBlock(state, mat, rtb, light, overlay, data);
            mat.func_227865_b_();
            this.bounds.grid = System.currentTimeMillis() << 54 >> 63;
            return state.getPickBlock(mc.field_71476_x, (IBlockReader)mc.field_71441_e, pos, (PlayerEntity)mc.field_71439_g);
        }
        TileEntity te = mc.field_71441_e.func_175625_s(pos);
        if (!(te instanceof IGridHost)) {
            return ItemStack.field_190927_a;
        }
        long m = 1L << gp;
        GridPart part = ((IGridHost)te).findPart(p -> (p.bounds & m) != 0L && p.ports.length != 0);
        if (part == null) {
            return ItemStack.field_190927_a;
        }
        this.bounds.grid = part.bounds;
        int x0 = this.bounds.func_199623_a(Direction.Axis.X);
        int y0 = this.bounds.func_199623_a(Direction.Axis.Y);
        int z0 = this.bounds.func_199623_a(Direction.Axis.Z);
        int x1 = this.bounds.func_199624_b(Direction.Axis.X);
        int y1 = this.bounds.func_199624_b(Direction.Axis.Y);
        int z1 = this.bounds.func_199624_b(Direction.Axis.Z);
        float scale = 0.5f / (float)Math.max(Math.max(x1 - x0, y1 - y0), z1 - z0);
        mat.func_227862_a_(scale, scale, scale);
        mat.func_227861_a_((double)(x0 + x1) * -0.125, (double)(y0 + y1) * -0.125, (double)(z0 + z1) * -0.125);
        part.fillModel(this.model.clear(), part.getLayer() >= 0 ? part.bounds : 0L);
        this.model.render(rtb.getBuffer(RenderType.func_228639_c_()), mat.func_227866_c_(), light, overlay);
        return part.asItemStack();
    }

    static {
        Quaternion q = new Quaternion(90.0f, 0.0f, 0.0f, true);
        for (Direction d : Direction.values()) {
            Quaternion quaternion = d.func_229384_a_();
            SignalProbeRenderer.ROTATIONS[d.ordinal() & 1 | d.func_176740_k().ordinal() << 1] = quaternion;
            quaternion.func_195890_a(q);
        }
    }
}

