/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.tileentity;

import cd4017be.api.grid.ExtGridPorts;
import cd4017be.api.grid.port.IEnergyAccess;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.block.BlockTE;
import cd4017be.lib.capability.BasicInventory;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.container.ContainerAutoCraft;
import cd4017be.rs_ctr2.tileentity.Machine;
import cd4017be.rs_ctr2.util.RefCraftingInventory;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class AutoCrafter
extends Machine
implements BlockTE.ITEBreak,
IUnnamedContainerProvider,
IGate,
IProbeInfo,
ISignalReceiver,
IInventoryAccess,
IPlayerPacketReceiver {
    private static final byte R_SUCCESS = 0;
    private static final byte R_MISSING_INGRED = 1;
    private static final byte R_INVALID_RECIPE = 2;
    private static final byte R_OUT_FULL = 4;
    private static final byte R_NO_ENERGY = 8;
    public final BasicInventory inv = new BasicInventory(16);
    public final RefCraftingInventory craftInv;
    private LazyOptional<IItemHandler> invCap;
    ISignalReceiver out = ISignalReceiver.NOP;
    IEnergyAccess energy = IEnergyAccess.NOP;
    ICraftingRecipe last;
    @Sync(to=-2147483647)
    public long pattern;
    @Sync(to=-2147483647)
    public int p2;
    @Sync(to=-2147483647)
    public int p1;
    @Sync
    public int clk;
    @Sync
    public int res;
    @Sync
    public int e;
    @Sync
    public byte slotI;
    @Sync
    public byte slot;
    @Sync
    public byte active;

    public AutoCrafter(TileEntityType<?> type) {
        super(type);
        this.craftInv = new RefCraftingInventory(3, 3, this.inv.items, this::index, null);
        this.p1 = 801;
        this.p2 = 9991764;
        this.e = -((Integer)Main.SERVER_CFG.craft.get()).intValue();
        this.updatePattern();
    }

    public int index(int slot) {
        return (int)(this.pattern >>> (slot << 2)) & 0xF;
    }

    private int craft() {
        int n;
        ItemStack stack;
        int i;
        int i2;
        int[] n2 = new int[16];
        for (i2 = 0; i2 < 9; ++i2) {
            int n3 = this.index(i2);
            n2[n3] = n2[n3] + 1;
        }
        for (i2 = 1; i2 < 16; ++i2) {
            int m;
            int ni = n2[i2];
            if (ni <= 0 || (m = this.inv.items[i2].func_190916_E()) <= 0 || m >= ni) continue;
            return 1;
        }
        if (this.last == null || !this.last.func_77569_a((IInventory)this.craftInv, this.field_145850_b)) {
            RecipeManager rm = this.field_145850_b.func_199532_z();
            this.last = rm.func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftInv, this.field_145850_b).orElse(null);
            if (this.last == null) {
                return 2;
            }
        }
        ItemStack out = this.last.func_77572_b((IInventory)this.craftInv);
        if (!this.inv.insertItem(this.index(10), out, true).func_190926_b()) {
            return 4;
        }
        boolean hasRem = false;
        NonNullList rem = this.last.func_179532_b((IInventory)this.craftInv);
        int x = this.index(9);
        ItemStack stackR = x != 0 ? this.inv.items[x] : ItemStack.field_190927_a;
        for (i = 0; i < rem.size(); ++i) {
            stack = (ItemStack)rem.get(i);
            n = stack.func_190916_E();
            if (n <= 0) continue;
            hasRem = true;
            if (this.craftInv.func_70301_a(i).func_190916_E() <= 1) continue;
            if (x == 0 || !ItemFluidUtil.canSlotStack((ItemStack)stackR, (ItemStack)stack)) {
                return 4;
            }
            if (stackR.func_190926_b()) {
                stackR = stack.func_77946_l();
                continue;
            }
            if ((n += stackR.func_190916_E()) <= stackR.func_77976_d()) {
                stackR.func_190920_e(n);
                continue;
            }
            return 4;
        }
        for (i = 0; i < 9; ++i) {
            this.craftInv.func_70298_a(i, 1);
        }
        this.inv.insertItem(this.index(10), out, false);
        if (hasRem) {
            for (i = 0; i < rem.size(); ++i) {
                stack = (ItemStack)rem.get(i);
                n = stack.func_190916_E();
                if (n <= 0) continue;
                if (this.craftInv.func_70301_a(i).func_190926_b()) {
                    if (x == 0 || !ItemFluidUtil.canSlotStack((ItemStack)stackR, (ItemStack)stack) || (n += stackR.func_190916_E()) > stack.func_77976_d()) {
                        this.craftInv.func_70299_a(i, stack);
                        continue;
                    }
                    stackR.func_190920_e(n);
                }
                this.inv.insertItem(x, stack, false);
            }
        }
        this.e = -((Integer)Main.SERVER_CFG.craft.get()).intValue();
        return 0;
    }

    public Object getHandler(int port) {
        switch (port) {
            case 0: {
                return this::updateClock;
            }
            case 1: {
                return (v, r) -> {
                    this.p2 = v;
                };
            }
            case 2: {
                return (v, r) -> {
                    this.p1 = v;
                };
            }
            case 3: 
            case 4: {
                return this;
            }
        }
        return null;
    }

    public void setHandler(int port, Object handler) {
        switch (port) {
            case 5: {
                this.out = ISignalReceiver.of((Object)handler);
                this.out.updateInput(this.res);
                break;
            }
            case 6: {
                this.energy = IEnergyAccess.of((Object)handler);
            }
        }
    }

    public void updateClock(int value, int rec) {
        this.clk = value;
        if ((~this.clk & this.clk) == 0) {
            return;
        }
        if (this.e < 0 && (this.e -= this.energy.transferEnergy(this.e, false)) < 0) {
            if (this.res != 8 && --rec >= 0) {
                this.res = 8;
                this.out.updateInput(8, rec);
            }
            return;
        }
        if (this.active == 0) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        this.active = (byte)(this.active | 2);
    }

    public void updateInput(int value, int rec) {
        this.slotI = (byte)(value & 0xF);
        if (this.slotI == this.slotI) {
            return;
        }
        if (this.active == 0) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        this.active = (byte)(this.active | 1);
    }

    public boolean evaluate() {
        if (this.unloaded) {
            return false;
        }
        if ((this.active & 1) != 0) {
            this.slot = this.slotI;
        }
        if ((this.active & 2) == 0) {
            this.active = 0;
            return false;
        }
        this.active = 0;
        this.updatePattern();
        this.res = this.craft();
        return this.res != this.res;
    }

    private void updatePattern() {
        this.pattern = (long)(this.p1 & 0xFFF) | (long)this.p2 << 12;
    }

    public void latchOut() {
        this.out.updateInput(this.res);
    }

    public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        inspector.accept(this.inv.items[this.slot & 0xF], 64);
    }

    public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
        ItemStack stack = this.inv.extractItem(this.slot & 0xF, amount, true);
        if (stack.func_190926_b() || !filter.test(stack)) {
            return 0;
        }
        amount = target.applyAsInt(stack);
        if (amount > 0) {
            this.inv.extractItem(this.slot & 0xF, amount, false);
        }
        return amount;
    }

    public int insert(ItemStack stack, int rec) {
        return stack.func_190916_E() - this.inv.insertItem(this.slot & 0xF, stack, false).func_190916_E();
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        if ((mode & 1) != 0) {
            nbt.func_218657_a("inv", (INBT)this.inv.write());
        }
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        if ((mode & 1) != 0) {
            this.inv.read(nbt.func_150295_c("inv", 10));
        }
    }

    @Override
    protected void init(ExtGridPorts ports, Orientation o) {
        ports.createPort(OrientedPart.port((Orientation)o, (int)50, (Direction)Direction.SOUTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)48, (Direction)Direction.SOUTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)49, (Direction)Direction.SOUTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)51, (Direction)Direction.SOUTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)55, (Direction)Direction.SOUTH, (int)2), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)52, (Direction)Direction.SOUTH, (int)0), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)54, (Direction)Direction.SOUTH, (int)1), true, true);
    }

    @Override
    public void onLoad() {
        if (!this.field_145850_b.field_72995_K && this.active != 0) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        super.onLoad();
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        if (this.invCap != null) {
            this.invCap.invalidate();
            this.invCap = null;
        }
    }

    public void onBreak(BlockState newState, boolean moving) {
        for (ItemStack stack : this.inv.items) {
            ItemFluidUtil.dropStack((ItemStack)stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
    }

    public ContainerAutoCraft createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAutoCraft(id, inv, this);
    }

    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.p2 = pkt.readInt();
                break;
            }
            case 1: {
                this.p1 = pkt.readInt();
                break;
            }
            default: {
                return;
            }
        }
        this.updatePattern();
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.autocraft", this.clk, this.p2, this.p1, this.slotI, this.res, -this.energy.transferEnergy(-2147483647, true)};
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.invCap == null) {
                this.invCap = LazyOptional.of(() -> this.inv);
            }
            return this.invCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

