/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.tileentity;

import cd4017be.api.grid.ExtGridPorts;
import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.api.grid.port.IEnergyAccess;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.tileentity.Machine;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BlockBreaker
extends Machine
implements ISignalReceiver,
IGate,
IBlockSupplier,
IProbeInfo {
    private static final int R_SUCCESS = 0;
    private static final int R_UNLOADED = 1;
    private static final int R_UNBREAKABLE = 2;
    private static final int R_INV_FULL = 4;
    private static final int R_NO_ENERGY = 8;
    ArrayList<ItemStack> drops = new ArrayList();
    IBlockSupplier target = this;
    IEnergyAccess energy = IEnergyAccess.NOP;
    ISignalReceiver out = ISignalReceiver.NOP;
    IInventoryAccess inv = IInventoryAccess.NOP;
    @Sync
    public int clk;
    @Sync
    public int res;
    @Sync
    public boolean active;

    public BlockBreaker(TileEntityType<?> type) {
        super(type);
    }

    public Object getHandler(int port) {
        return port == 0 ? this : null;
    }

    public void setHandler(int port, Object handler) {
        switch (port) {
            case 1: {
                this.out = ISignalReceiver.of((Object)handler);
                break;
            }
            case 2: {
                this.energy = IEnergyAccess.of((Object)handler);
                break;
            }
            case 3: {
                this.inv = IInventoryAccess.of((Object)handler);
                break;
            }
            case 4: {
                this.target = IBlockSupplier.of((Object)handler, (IBlockSupplier)this);
            }
        }
    }

    @Override
    protected void init(ExtGridPorts ports, Orientation o) {
        ports.createPort(OrientedPart.port((Orientation)o, (int)5, (Direction)Direction.NORTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)6, (Direction)Direction.NORTH, (int)0), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)9, (Direction)Direction.NORTH, (int)1), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)10, (Direction)Direction.NORTH, (int)2), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)57, (Direction)Direction.SOUTH, (int)4), true, true);
    }

    public void updateInput(int value, int rec) {
        this.clk = value;
        if ((~this.clk & this.clk) != 0 && !this.active) {
            this.active = true;
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
    }

    public boolean evaluate() {
        this.active = false;
        return !this.unloaded;
    }

    public void latchOut() {
        IProfiler profiler = this.field_145850_b.func_217381_Z();
        profiler.func_76320_a("rs_ctr2:BlockBreaker");
        int res = this.process(profiler);
        profiler.func_76319_b();
        if (res != this.res) {
            this.res = res;
            this.out.updateInput(this.res);
        }
    }

    private int process(IProfiler profiler) {
        TileEntity te;
        if (!this.drops.isEmpty()) {
            return this.eject();
        }
        ImmutablePair b = this.target.getBlock();
        if (b == null) {
            return 1;
        }
        ServerWorld world = (ServerWorld)b.right;
        BlockPos pos = (BlockPos)b.left;
        BlockState state = world.func_180495_p(pos);
        float h = state.func_185887_b((IBlockReader)world, pos);
        if (h < 0.0f) {
            return 2;
        }
        int e = -((int)(h * (float)((Integer)Main.SERVER_CFG.hardness_break.get()).intValue())) - (Integer)Main.SERVER_CFG.block_break.get();
        if (!state.func_235783_q_()) {
            e >>= 1;
        }
        if (this.energy.transferEnergy(e, true) != e) {
            return 8;
        }
        TileEntity tileEntity = te = state.hasTileEntity() ? world.func_175625_s(pos) : null;
        if (!world.func_175655_b(pos, false)) {
            return 2;
        }
        this.energy.transferEnergy(e, false);
        profiler.func_76320_a("collect_loot");
        world.field_73012_v.setSeed(e);
        for (ItemStack stack : Block.func_220070_a((BlockState)state, (ServerWorld)world, (BlockPos)pos, (TileEntity)te)) {
            this.addDrop(stack);
        }
        if (te != null) {
            for (ItemEntity ie : world.func_225317_b(ItemEntity.class, new AxisAlignedBB(pos))) {
                this.addDrop(ie.func_92059_d());
                world.func_217467_h((Entity)ie);
            }
        }
        profiler.func_76319_b();
        return this.drops.isEmpty() ? 0 : 4;
    }

    private int eject() {
        for (int i = this.drops.size() - 1; i >= 0; --i) {
            ItemStack stack = this.drops.get(i);
            stack.func_190918_g(this.inv.applyAsInt(stack));
            if (stack.func_190926_b()) {
                this.drops.remove(i);
                continue;
            }
            this.drops.set(i, stack);
        }
        return this.drops.isEmpty() ? 0 : 4;
    }

    private void addDrop(ItemStack stack) {
        stack.func_190918_g(this.inv.applyAsInt(stack));
        if (!stack.func_190926_b()) {
            this.drops.add(stack);
        }
    }

    public ImmutablePair<BlockPos, ServerWorld> getBlock(int rec) {
        return this.ports.isLinked(4) ? null : new ImmutablePair((Object)this.field_174879_c.func_177972_a(this.orientation().b), (Object)((ServerWorld)this.field_145850_b));
    }

    @Override
    public void onLoad() {
        if (this.active && !this.field_145850_b.field_72995_K) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        super.onLoad();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (ItemStack stack : this.drops) {
            ItemFluidUtil.dropStack((ItemStack)stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
        }
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.block_breaker", this.clk, this.res, -this.energy.transferEnergy(-2147483647, true), this.inv != IInventoryAccess.NOP, IBlockSupplier.toString((IBlockSupplier)this.target)};
    }
}

