/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.tileentity;

import cd4017be.lib.network.Sync;
import cd4017be.lib.render.model.PartModel;
import cd4017be.lib.render.model.TileEntityModel;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IFrame;
import cd4017be.rs_ctr2.api.IFrameOperator;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import org.apache.commons.lang3.ArrayUtils;

public class Frame
extends BaseTileEntity
implements IFrame {
    @Sync(to=7)
    public long dist;
    private long[] listeners = ArrayUtils.EMPTY_LONG_ARRAY;

    public Frame(TileEntityType<?> type) {
        super(type);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.field_145850_b.field_72995_K || this.dist != 0L) {
            return;
        }
        int lim = (Integer)Main.SERVER_CFG.frame_range.get();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        block0: for (Direction d : Direction.values()) {
            pos.func_189533_g((Vector3i)this.field_174879_c);
            for (int i = 1; i <= lim; ++i) {
                TileEntity te = this.field_145850_b.func_175625_s((BlockPos)pos.func_189536_c(d));
                if (!(te instanceof Frame)) continue;
                ((Frame)te).setDist(d.func_176734_d(), i);
                this.setDist(d, i);
                continue block0;
            }
            this.setDist(d, 0);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        BlockPos pos = this.field_174879_c;
        for (Direction d : Direction.values()) {
            TileEntity te;
            int i = this.getDist(d);
            if (i == 0 || !((te = this.field_145850_b.func_175625_s(pos.func_177967_a(d, i))) instanceof Frame)) continue;
            int j = this.getDist(d.func_176734_d());
            if (j != 0) {
                j += i;
            }
            ((Frame)te).setDist(d.func_176734_d(), j);
        }
        this.updateListeners();
    }

    private BlockPos pos(long p) {
        return this.field_174879_c.func_177982_a((int)((short)p), (int)((short)(p >> 16)), (int)((short)(p >> 32)));
    }

    private long pos(BlockPos pos) {
        long dx = pos.func_177958_n() - this.field_174879_c.func_177958_n() & 0xFFFF;
        long dy = pos.func_177956_o() - this.field_174879_c.func_177956_o() & 0xFFFF;
        long dz = pos.func_177952_p() - this.field_174879_c.func_177952_p() & 0xFFFF;
        return dx | dy << 16 | dz << 32;
    }

    private void updateListeners() {
        for (int i = 0; i < this.listeners.length; ++i) {
            long l = this.listeners[i];
            if (l == 0L) continue;
            TileEntity te = this.field_145850_b.func_175625_s(this.pos(l));
            if (!(te instanceof IFrameOperator)) {
                this.listeners[i] = 0L;
                continue;
            }
            ((IFrameOperator)te).onFrameChange(this);
        }
    }

    @Override
    public void setDist(Direction d, int i) {
        if (i > 255) {
            i = 0;
        }
        int s = d.ordinal() * 8;
        this.dist = this.dist & (255L << s ^ 0xFFFFFFFFFFFFFFFFL) | (long)i << s;
        this.updateListeners();
        this.clientDirty(true);
    }

    @Override
    public int getDist(Direction d) {
        return (int)(this.dist >> d.ordinal() * 8) & 0xFF;
    }

    @Override
    public void addListener(BlockPos pos) {
        int l;
        long p = this.pos(pos);
        int j = l = this.listeners.length;
        for (int i = 0; i < l; ++i) {
            long p1 = this.listeners[i];
            if (p1 == p) {
                return;
            }
            if (p1 != 0L || i >= j) continue;
            j = i;
        }
        if (j >= l) {
            this.listeners = Arrays.copyOf(this.listeners, Math.max(l + 1, l << 1));
        }
        this.listeners[j] = p;
    }

    @Override
    public void removeListener(BlockPos pos) {
        long p = this.pos(pos);
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != p) continue;
            this.listeners[i] = 0L;
            return;
        }
    }

    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        if ((mode & 1) != 0) {
            nbt.func_197644_a("refs", this.listeners);
        }
    }

    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        if ((mode & 1) != 0) {
            long[] arr = nbt.func_197645_o("refs");
            int j = 0;
            for (int i = 0; i < arr.length; ++i) {
                long x = arr[i];
                if (x == 0L) continue;
                if (i != j) {
                    arr[j] = x;
                }
                ++j;
            }
            this.listeners = Arrays.copyOf(arr, j);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.requestModelDataUpdate();
    }

    public IModelData getModelData() {
        ModelDataMap data = TileEntityModel.MODEL_DATA_BUILDER.build();
        ArrayList<PartModel> list = new ArrayList<PartModel>(6);
        data.setData(PartModel.PART_MODELS, list);
        for (Direction d : Direction.values()) {
            list.add(new PartModel(this.getDist(d) > 0 ? "1" : "0").orient(Orientation.byBack((Direction)d).o, 0.5f, 0.5f, 0.5f));
        }
        return data;
    }
}

