/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.tileentity;

import cd4017be.api.grid.ExtGridPorts;
import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.lib.block.BlockTE;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IFrame;
import cd4017be.rs_ctr2.api.IFrameOperator;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.tileentity.Machine;
import cd4017be.rs_ctr2.util.Utils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class FrameController
extends Machine
implements IFrameOperator,
IBlockSupplier,
IGate,
IProbeInfo,
BlockTE.ITEInteract {
    public final int[] region = new int[9];
    public ImmutablePair<BlockPos, ServerWorld> block;
    @Sync(to=7)
    public int frames;
    @Sync(to=7)
    public int missing;
    @Sync
    public int dx;
    @Sync
    public int dy;
    @Sync
    public int dz;
    @Sync
    public boolean active;
    @Sync(to=7)
    public boolean visible = true;

    public FrameController(TileEntityType<?> type) {
        super(type);
    }

    public void setHandler(int port, Object handler) {
    }

    public Object getHandler(int port) {
        switch (port) {
            case 0: {
                return (v, r) -> {
                    this.dx = v;
                    this.update(this.dx, this.dx);
                };
            }
            case 1: {
                return (v, r) -> {
                    this.dy = v;
                    this.update(this.dy, this.dy);
                };
            }
            case 2: {
                return (v, r) -> {
                    this.dz = v;
                    this.update(this.dz, this.dz);
                };
            }
            case 3: {
                return this;
            }
        }
        return null;
    }

    private void update(int old, int val) {
        if (old == val || this.active) {
            return;
        }
        this.active = true;
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    public boolean evaluate() {
        int by;
        this.active = false;
        if (this.unloaded) {
            return false;
        }
        if (this.missing < 0) {
            this.updateFrame();
        }
        this.block = null;
        if (this.missing == 0 && (by = this.region[4] + this.dy) >= this.region[3] && by <= this.region[5]) {
            int bx = this.region[1];
            int bz = this.region[7];
            switch (this.orientation()) {
                default: {
                    bx += this.dx;
                    bz += this.dz;
                    break;
                }
                case N12: {
                    bx -= this.dx;
                    bz -= this.dz;
                    break;
                }
                case E12: {
                    bx += this.dz;
                    bz -= this.dx;
                    break;
                }
                case W12: {
                    bx -= this.dz;
                    bz += this.dx;
                }
            }
            if (bx >= this.region[0] && bx <= this.region[2] && bz >= this.region[6] && bz <= this.region[8]) {
                this.block = ImmutablePair.of((Object)new BlockPos(bx, by, bz), (Object)((ServerWorld)this.field_145850_b));
            }
        }
        this.clientDirty(false);
        return false;
    }

    public ImmutablePair<BlockPos, ServerWorld> getBlock(int rec) {
        return this.block;
    }

    @Override
    protected void init(ExtGridPorts ports, Orientation o) {
        ports.createPort(OrientedPart.port((Orientation)o, (int)3, (Direction)Direction.NORTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)2, (Direction)Direction.NORTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)1, (Direction)Direction.NORTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)0, (Direction)Direction.NORTH, (int)4), false, true);
        this.missing |= Integer.MIN_VALUE;
        this.update(0, 1);
    }

    private void updateFrame() {
        IFrame frame = this.originFrame();
        if (frame == null) {
            this.setNullRegion();
            return;
        }
        this.frames = frame.findRegion(this.region);
        BlockPos pos = this.field_174879_c;
        this.missing = this.frames & ~IFrameOperator.findFrames(this.field_145850_b, this.region, this.frames, f -> f.addListener(pos));
    }

    private IFrame originFrame() {
        boolean valid = this.region[2] > this.region[0] && this.region[5] > this.region[3] && this.region[8] > this.region[6];
        BlockPos pos = this.field_174879_c;
        if (valid) {
            IFrameOperator.findFrames(this.field_145850_b, this.region, this.frames & ~this.missing, f -> f.removeListener(pos));
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.region[1], this.region[4], this.region[7]));
            if (te instanceof IFrame) {
                return (IFrame)te;
            }
        }
        return IFrameOperator.findNearest(this.field_145850_b, pos, (Integer)Main.SERVER_CFG.device_range.get());
    }

    private void setNullRegion() {
        this.region[1] = this.region[2] = this.field_174879_c.func_177958_n();
        this.region[0] = this.region[2];
        this.region[4] = this.region[5] = this.field_174879_c.func_177956_o();
        this.region[3] = this.region[5];
        this.region[7] = this.region[8] = this.field_174879_c.func_177952_p();
        this.region[6] = this.region[8];
        this.frames = 0;
        this.missing = -1;
    }

    @Override
    public void onFrameChange(IFrame frame) {
        if (frame.exists() ^ this.missing != 0) {
            return;
        }
        this.missing |= Integer.MIN_VALUE;
        this.update(0, 1);
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        nbt.func_74783_a("region", this.region);
        if (this.block != null) {
            nbt.func_74772_a("block", ((BlockPos)this.block.left).func_218275_a());
        }
        super.storeState(nbt, mode);
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        int[] arr = nbt.func_74759_k("region");
        System.arraycopy(arr, 0, this.region, 0, Math.min(9, arr.length));
        this.block = nbt.func_150297_b("block", 4) ? ImmutablePair.of((Object)BlockPos.func_218283_e((long)nbt.func_74763_f("block")), null) : null;
        super.loadState(nbt, mode);
    }

    @Override
    public void onLoad() {
        if (this.field_145850_b instanceof ServerWorld && this.block != null) {
            this.block = ImmutablePair.of((Object)this.block.left, (Object)((ServerWorld)this.field_145850_b));
        }
        if (this.active && !this.field_145850_b.field_72995_K) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        super.onLoad();
    }

    @Override
    public Object[] stateInfo() {
        int z1;
        int z0;
        int x1;
        int x0;
        switch (this.orientation()) {
            default: {
                x0 = 0;
                x1 = 2;
                z0 = 6;
                z1 = 8;
                break;
            }
            case N12: {
                x0 = 2;
                x1 = 0;
                z0 = 8;
                z1 = 6;
                break;
            }
            case E12: {
                x0 = 8;
                x1 = 6;
                z0 = 0;
                z1 = 2;
                break;
            }
            case W12: {
                x0 = 6;
                x1 = 8;
                z0 = 2;
                z1 = 0;
            }
        }
        int x = this.region[x0 + x1 >> 1];
        int z = this.region[z0 + z1 >> 1];
        x0 = this.region[x0] - x;
        x1 = this.region[x1] - x;
        if (x0 > x1) {
            x0 = -x0;
            x1 = -x1;
        }
        if ((z0 = this.region[z0] - z) > (z1 = this.region[z1] - z)) {
            z0 = -z0;
            z1 = -z1;
        }
        int y = this.region[4];
        return new Object[]{"state.rs_ctr2.frame_controller", this.dx, x0, x1, this.dy, this.region[3] - y, this.region[5] - y, this.dz, z0, z1, IBlockSupplier.toString((IBlockSupplier)this)};
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.region[0], (double)this.region[3], (double)this.region[6], (double)(this.region[2] + 1), (double)(this.region[5] + 1), (double)(this.region[8] + 1));
    }

    public ActionResultType onActivated(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return player.func_184586_b(hand).func_190926_b() ? Utils.serverAction(player, () -> {
            this.visible = !this.visible;
            this.clientDirty(false);
            player.func_146105_b((ITextComponent)new TranslationTextComponent(this.visible ? "msg.rs_ctr2.visible" : "msg.rs_ctr2.invisible"), true);
        }) : ActionResultType.PASS;
    }

    public void onClicked(PlayerEntity player) {
    }
}

