/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.tileentity;

import cd4017be.api.grid.ExtGridPorts;
import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.api.grid.port.IEnergyAccess;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.block.BlockTE;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.SaferFakePlayer;
import cd4017be.math.Linalg;
import cd4017be.math.Orient;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.container.ContainerItemPlacer;
import cd4017be.rs_ctr2.tileentity.Machine;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ItemPlacer
extends Machine
implements IGate,
IBlockSupplier,
ISignalReceiver,
BlockTE.ITEPlace,
IUnnamedContainerProvider,
IProbeInfo {
    private static final int R_SUCCESS = 0;
    private static final int R_UNLOADED = 1;
    private static final int R_UNBREAKABLE = 2;
    private static final int R_INV_FULL = 4;
    private static final int R_NO_ENERGY = 8;
    private static final CompoundNBT DEFAULT_DATA = new CompoundNBT();
    private CompoundNBT playerData = DEFAULT_DATA;
    private FakePlayer player = null;
    IBlockSupplier target = this;
    public ItemStack oldStack;
    IEnergyAccess energy = IEnergyAccess.NOP;
    ISignalReceiver out = ISignalReceiver.NOP;
    IInventoryAccess inv = IInventoryAccess.NOP;
    @Sync
    public int clk;
    @Sync
    public int res;
    @Sync(to=-2147483647)
    public int aim0;
    public int aim;
    @Sync
    public boolean active;

    public ItemPlacer(TileEntityType<?> type) {
        super(type);
    }

    public void onPlace(BlockState state, ItemStack stack, LivingEntity entity) {
        if (this.field_145850_b instanceof ServerWorld && entity instanceof PlayerEntity) {
            this.player = new SaferFakePlayer((ServerWorld)this.field_145850_b, ((PlayerEntity)entity).func_146103_bH());
            if (this.playerData != null) {
                this.player.field_71071_by.func_70443_b(this.playerData.func_150295_c("inv", 10));
                this.player.field_71071_by.field_70461_c = this.playerData.func_74771_c("sel") & 0xFF;
                this.playerData = null;
            }
        }
    }

    public ISignalReceiver getHandler(int port) {
        return port == 5 ? (v, r) -> {
            this.aim0 = v;
        } : (port == 0 ? this : null);
    }

    public void setHandler(int port, Object handler) {
        switch (port) {
            case 1: {
                this.out = ISignalReceiver.of((Object)handler);
                break;
            }
            case 2: {
                this.energy = IEnergyAccess.of((Object)handler);
                break;
            }
            case 3: {
                this.inv = IInventoryAccess.of((Object)handler);
                break;
            }
            case 4: {
                this.target = IBlockSupplier.of((Object)handler, (IBlockSupplier)this);
            }
        }
    }

    @Override
    protected void init(ExtGridPorts ports, Orientation o) {
        ports.createPort(OrientedPart.port((Orientation)o, (int)5, (Direction)Direction.NORTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)6, (Direction)Direction.NORTH, (int)0), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)9, (Direction)Direction.NORTH, (int)1), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)10, (Direction)Direction.NORTH, (int)2), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)57, (Direction)Direction.SOUTH, (int)4), true, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)1, (Direction)Direction.NORTH, (int)0), false, true);
    }

    public void updateInput(int value, int rec) {
        this.clk = value;
        if ((~this.clk & this.clk) != 0 && !this.active) {
            this.active = true;
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
    }

    public boolean evaluate() {
        this.active = false;
        this.aim = this.aim0;
        return !this.unloaded;
    }

    public void latchOut() {
        IProfiler profiler = this.field_145850_b.func_217381_Z();
        profiler.func_76320_a("rs_ctr2:ItemPlacer");
        int res = this.process(profiler, this.getPlayer());
        profiler.func_76319_b();
        if (res != this.res) {
            this.res = res;
            this.out.updateInput(this.res);
        }
    }

    private int process(IProfiler profiler, FakePlayer player) {
        if (this.oldStack != null) {
            if (!this.restock(player)) {
                return 4;
            }
            this.oldStack = null;
            return 0;
        }
        ImmutablePair b = this.target.getBlock();
        if (b == null) {
            return 1;
        }
        BlockPos pos = (BlockPos)b.left;
        ServerWorld world = (ServerWorld)b.right;
        int e = -((Integer)Main.SERVER_CFG.item_place.get()).intValue();
        if (this.energy.transferEnergy(e, true) != e) {
            return 8;
        }
        BlockRayTraceResult res = ItemPlacer.setupInteraction(player, world, pos, this.orientation(), this.aim);
        Hand hand = player.field_71071_by.field_70461_c < 36 ? Hand.MAIN_HAND : Hand.OFF_HAND;
        ItemStack stack = player.func_184586_b(hand);
        this.oldStack = stack.func_77946_l();
        ActionResultType ar = ItemPlacer.interact(player, stack, hand, res, (this.aim & 0x4000) != 0);
        if (ar == null) {
            return 2;
        }
        this.energy.transferEnergy(e, false);
        if ((this.aim & 0x80) == 0 && !this.restock(player)) {
            return 4;
        }
        this.oldStack = null;
        return ar.func_226246_a_() ? 0 : 2;
    }

    private boolean restock(FakePlayer player) {
        ItemStack old;
        PlayerInventory pinv = player.field_71071_by;
        int i = pinv.field_70461_c;
        ItemStack stack = pinv.func_70301_a(i);
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)(old = this.oldStack))) {
            return true;
        }
        if (!stack.func_190926_b()) {
            stack.func_190918_g(this.inv.applyAsInt(stack));
            if (!stack.func_190926_b()) {
                return false;
            }
        }
        if (old.func_190926_b()) {
            return true;
        }
        return this.inv.transfer(old.func_77976_d(), arg_0 -> ((ItemStack)old).func_77969_a(arg_0), s -> {
            ItemStack s1 = pinv.func_70301_a(i);
            if (s1.func_190926_b()) {
                pinv.func_70299_a(i, s.func_77946_l());
            } else {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s1, (ItemStack)s)) {
                    return 0;
                }
                s1.func_190917_f(s.func_190916_E());
            }
            return s.func_190916_E();
        }) > 0;
    }

    public void resetRestock(int slot) {
        if (slot == this.player.field_71071_by.field_70461_c) {
            this.oldStack = null;
        }
    }

    private static BlockRayTraceResult setupInteraction(FakePlayer player, ServerWorld world, BlockPos pos, Orientation o, int aim) {
        int i = aim & 0x3F;
        player.field_71071_by.field_70461_c = i < 36 ? i : 40;
        player.func_213301_b((aim & 0x1000) != 0 ? Pose.CROUCHING : Pose.STANDING);
        boolean air = (aim & 0x8000) != 0;
        float[] p = new float[]{0.46875f - (float)(aim >> 16 & 0xF) * 0.0625f, (float)(aim >> 20 & 0xF) * 0.0625f - 0.46875f, air ? 0.0f : -2.0f};
        aim = aim >> 8 & 0xF;
        o = o.apply(Orientation.byIndex((int)aim));
        Linalg.dadd((int)3, (float[])Orient.orient((int)o.o, (float[])p), (float)0.5f);
        Vector3d vec = new Vector3d((double)p[0] + (double)pos.func_177958_n(), (double)p[1] + (double)pos.func_177956_o(), (double)p[2] + (double)pos.func_177952_p());
        player.field_70170_p = world;
        player.func_70012_b(vec.field_72450_a, vec.field_72448_b - (double)player.func_70047_e(), vec.field_72449_c, (float)((aim & 3) * 90), (float)((((aim >> 2) + 1 & 3) - 1) * -90));
        player.field_70127_C = player.field_70125_A;
        player.field_70761_aq = player.field_70126_B = player.field_70177_z;
        player.field_70760_ar = player.field_70126_B;
        player.field_70759_as = player.field_70126_B;
        player.field_70758_at = player.field_70126_B;
        if (air) {
            return null;
        }
        p = Orient.orient((int)o.o, (float[])Linalg.vec((float[])new float[]{0.0f, 0.0f, -3.5f}));
        Vector3d dir = vec.func_72441_c((double)p[0], (double)p[1], (double)p[2]);
        BlockState state = world.func_180495_p(pos);
        BlockRayTraceResult res = state.func_196954_c((IBlockReader)world, pos).func_212433_a(vec, dir, pos);
        if (res != null) {
            return res;
        }
        return new BlockRayTraceResult(dir, o.b.func_176734_d(), pos, false);
    }

    private static ActionResultType interact(FakePlayer player, ItemStack stack, Hand hand, BlockRayTraceResult res, boolean replace) {
        PlayerInteractionManager pim = player.field_71134_c;
        if (res == null) {
            return stack.func_190926_b() ? ActionResultType.PASS : pim.func_187250_a((ServerPlayerEntity)player, player.field_70170_p, stack, hand);
        }
        if (replace && !new BlockItemUseContext((PlayerEntity)player, hand, stack, res).func_196012_c()) {
            return null;
        }
        return pim.func_219441_a((ServerPlayerEntity)player, player.field_70170_p, stack, hand, res);
    }

    public ImmutablePair<BlockPos, ServerWorld> getBlock(int rec) {
        return this.ports.isLinked(4) ? null : new ImmutablePair((Object)this.field_174879_c.func_177972_a(this.orientation().b), (Object)((ServerWorld)this.field_145850_b));
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        if ((mode & 1) != 0) {
            if (this.oldStack != null) {
                nbt.func_218657_a("stock", (INBT)this.oldStack.serializeNBT());
            }
            if (this.player != null) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_218657_a("inv", (INBT)this.player.field_71071_by.func_70442_a(new ListNBT()));
                tag.func_186854_a("uuid", this.player.func_146103_bH().getId());
                tag.func_74778_a("name", this.player.func_146103_bH().getName());
                tag.func_74774_a("sel", (byte)this.player.field_71071_by.field_70461_c);
                nbt.func_218657_a("FP", (INBT)tag);
            } else if (this.playerData != null) {
                nbt.func_218657_a("FP", (INBT)this.playerData);
            }
        }
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        if ((mode & 1) != 0) {
            this.oldStack = !nbt.func_150297_b("stock", 10) ? null : ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stock"));
            this.playerData = nbt.func_74775_l("FP");
            this.aim = this.aim0;
        }
    }

    @Override
    public void onLoad() {
        if (this.active && !this.field_145850_b.field_72995_K) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        super.onLoad();
    }

    public FakePlayer getPlayer() {
        if (this.player != null) {
            return this.player;
        }
        CompoundNBT nbt = this.playerData;
        if (!nbt.func_150297_b("uuid", 11)) {
            nbt.func_218657_a("uuid", DEFAULT_DATA.func_74781_a("uuid"));
        }
        GameProfile gp = new GameProfile(nbt.func_186857_a("uuid"), nbt.func_74779_i("name"));
        this.player = new SaferFakePlayer((ServerWorld)this.field_145850_b, gp);
        this.player.field_71071_by.func_70443_b(nbt.func_150295_c("inv", 10));
        this.player.field_71071_by.field_70461_c = nbt.func_74771_c("sel") & 0xFF;
        this.playerData = null;
        return this.player;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return this.getPlayer().getCapability(cap, side);
    }

    public ContainerItemPlacer createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerItemPlacer(id, inv, this);
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.item_placer", this.clk, this.aim0, this.res, -this.energy.transferEnergy(-2147483647, true), this.inv != IInventoryAccess.NOP, IBlockSupplier.toString((IBlockSupplier)this.target)};
    }

    static {
        DEFAULT_DATA.func_74778_a("name", "FakePlayer");
        DEFAULT_DATA.func_186854_a("uuid", new UUID(0L, 0L));
    }
}

