/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.tileentity;

import cd4017be.api.grid.ExtGridPorts;
import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.block.AccessPipe;
import cd4017be.rs_ctr2.tileentity.Machine;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class PipeController
extends Machine
implements IInventoryAccess,
IBlockSupplier,
ISignalReceiver,
IGate,
IProbeInfo {
    public static int MAX_LEN = 256;
    ImmutablePair<BlockPos, ServerWorld> block;
    @Sync
    public BlockPos end;
    @Sync
    public int len;
    @Sync
    public int dir;
    @Sync(type=Sync.Type.Enum)
    public Direction back = Direction.DOWN;
    @Sync
    public boolean update;
    private int tick;

    public PipeController(TileEntityType<?> type) {
        super(type);
    }

    @Override
    protected void init(ExtGridPorts ports, Orientation o) {
        ports.createPort(OrientedPart.port((Orientation)o, (int)5, (Direction)Direction.NORTH, (int)0), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)6, (Direction)Direction.NORTH, (int)2), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)9, (Direction)Direction.NORTH, (int)4), false, true);
        ports.createPort(OrientedPart.port((Orientation)o, (int)10, (Direction)Direction.NORTH, (int)4), false, true);
    }

    public Object getHandler(int port) {
        return this;
    }

    public void setHandler(int port, Object handler) {
    }

    public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        inspector.accept(new ItemStack((IItemProvider)Content.access_pipe, this.len), MAX_LEN);
    }

    public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
        ItemStack stack = new ItemStack((IItemProvider)Content.access_pipe);
        if (!filter.test(stack)) {
            return 0;
        }
        BlockPos pos = this.end;
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_177230_c() != Content.ACCESS_PIPE) {
            this.len = 0;
            if (!pos.equals((Object)this.field_174879_c)) {
                pos = this.field_174879_c;
                this.block = null;
            }
            return 0;
        }
        if (target.applyAsInt(stack) == 0) {
            return 0;
        }
        this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        this.updateBlock(pos.func_177972_a((Direction)state.func_177229_b(AccessPipe.BACK)));
        --this.len;
        return 1;
    }

    public int insert(ItemStack stack, int rec) {
        BlockState place;
        BlockPos pos;
        BlockState state;
        if (this.len >= MAX_LEN || stack.func_77973_b() != Content.access_pipe) {
            return 0;
        }
        if (!Content.ACCESS_PIPE.validSource(this.field_145850_b.func_180495_p(this.end))) {
            this.updateBlock(this.field_174879_c);
            this.len = 0;
        }
        if ((state = this.field_145850_b.func_180495_p(pos = this.end.func_177967_a(this.back, -1))) == (place = (BlockState)Content.ACCESS_PIPE.func_176223_P().func_206870_a(AccessPipe.BACK, (Comparable)this.back))) {
            this.updateBlock(pos);
            ++this.len;
            return 0;
        }
        if (!state.isAir((IBlockReader)this.field_145850_b, pos) && !state.func_185904_a().func_76224_d()) {
            return 0;
        }
        if (!this.field_145850_b.func_175656_a(pos, place)) {
            return 0;
        }
        this.updateBlock(pos);
        ++this.len;
        return 1;
    }

    private void updateBlock(BlockPos pos) {
        this.end = pos;
        this.block = null;
        this.tick = -1;
    }

    public ImmutablePair<BlockPos, ServerWorld> getBlock(int rec) {
        if (this.tick != GateUpdater.TICK) {
            this.tick = GateUpdater.TICK;
            if (!this.field_145850_b.func_195588_v(this.end) || !Content.ACCESS_PIPE.validSource(this.field_145850_b.func_180495_p(this.end))) {
                this.block = null;
            } else if (this.block == null) {
                this.block = ImmutablePair.of((Object)this.end.func_177967_a(this.back, -1), (Object)((ServerWorld)this.field_145850_b));
            }
        }
        return this.block;
    }

    public void updateInput(int value, int rec) {
        this.dir = value & 7;
        if (this.dir == this.dir || this.update) {
            return;
        }
        this.update = true;
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    public boolean evaluate() {
        this.update = false;
        if (this.unloaded) {
            return false;
        }
        this.back = this.orientation().apply(Direction.func_82600_a((int)this.dir));
        this.updateBlock(this.end);
        return true;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.pipe_controller", this.dir, this.len, IBlockSupplier.toString((IBlockSupplier)this)};
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        if (this.end == null) {
            this.end = pos;
        }
    }
}

