/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.capability;

import com.fuzs.puzzleslib_ra.capability.CapabilityStorage;
import com.google.common.base.CaseFormat;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public abstract class CapabilityController {
    public CapabilityController() {
        this.register();
        this.addListeners();
    }

    protected abstract void register();

    private void addListeners() {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::onAttachItemStackCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, this::onAttachEntityCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(TileEntity.class, this::onAttachTileEntityCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(World.class, this::onAttachWorldCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Chunk.class, this::onAttachChunkCapabilities);
    }

    protected void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
    }

    protected void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> evt) {
    }

    protected void onAttachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> evt) {
    }

    protected void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> evt) {
    }

    protected void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> evt) {
    }

    protected static <T> void register(Class<T> type, Callable<? extends T> factory) {
        CapabilityManager.INSTANCE.register(type, new CapabilityStorage(), factory);
    }

    protected static ResourceLocation getRegistryKey(String modId, String name) {
        String formattedName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        return new ResourceLocation(modId, formattedName);
    }

    @Nonnull
    public static <T> LazyOptional<T> getCapability(ICapabilityProvider provider, Capability<T> cap) {
        return provider.getCapability(cap);
    }
}

