/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.config;

import com.fuzs.puzzleslib_ra.config.ConfigTypeEntry;
import java.io.File;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigBuilder {
    private final EnumMap<ModConfig.Type, ConfigTypeEntry> configTypeEntries = Stream.of(ModConfig.Type.values()).collect(Collectors.toMap(Function.identity(), ConfigTypeEntry::new, (key1, key2) -> key1, () -> new EnumMap(ModConfig.Type.class)));
    private ModConfig.Type activeType;

    public boolean addSpec(ModConfig.Type type, ForgeConfigSpec spec) {
        return this.configTypeEntries.get(type).addSpec(spec);
    }

    @Nullable
    public ForgeConfigSpec getSpec(ModConfig.Type type) {
        return this.configTypeEntries.get(type).getSpec();
    }

    public boolean isSpecNotBuilt(ModConfig.Type type) {
        return this.configTypeEntries.get(type).isSpecNotBuilt();
    }

    public boolean isSpecNotValid(ModConfig.Type type) {
        return this.isSpecNotBuilt(type) || !this.configTypeEntries.get(type).getSpec().isLoaded();
    }

    public void create(String category, Consumer<ForgeConfigSpec.Builder> options, ModConfig.Type type, String ... comments) {
        this.activeType = type;
        ForgeConfigSpec.Builder builder = this.configTypeEntries.get(type).getBuilder();
        if (comments.length != 0) {
            builder.comment(comments);
        }
        builder.push(category);
        options.accept(builder);
        builder.pop();
        this.activeType = null;
    }

    public void registerConfigs(ModLoadingContext context) {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            ConfigTypeEntry typeEntry = this.configTypeEntries.get(type);
            if (!typeEntry.canBuildSpec()) continue;
            context.registerConfig(type, typeEntry.getSpec(), typeEntry.getName(context));
        }
    }

    public void moveToFolder(String ... folderName) {
        if (folderName.length > 0) {
            String prefix = String.join((CharSequence)File.separator, folderName) + File.separator;
            this.configTypeEntries.values().forEach(typeEntry -> typeEntry.setPrefix(prefix));
        }
    }

    public ModConfig.Type getActiveType() {
        return this.activeType;
    }
}

