/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.config;

import com.fuzs.puzzleslib_ra.PuzzlesLib;
import com.fuzs.puzzleslib_ra.config.ConfigBuilder;
import com.fuzs.puzzleslib_ra.config.ConfigValueEntry;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigManager {
    private static ConfigManager instance;
    private final Map<String, ConfigBuilder> configBuilders = Maps.newHashMap();
    private final Map<String, ConfigValueEntry<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> configEntries = Maps.newHashMap();
    private final Map<Runnable, ConfigLoading> configListeners = Maps.newHashMap();

    private ConfigManager() {
    }

    public void load() {
        this.getBuilder().registerConfigs(ModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModConfig);
    }

    public void onModConfig(ModConfig.ModConfigEvent evt) {
        String modid = evt.getConfig().getModId();
        ModConfig.Type type = evt.getConfig().getType();
        if (this.getBuilder(modid).isSpecNotValid(type)) {
            PuzzlesLib.LOGGER.error("Unable to get values from " + type.extension() + " config for " + modid + " during " + (evt instanceof ModConfig.Loading ? "loading" : "reloading") + " phase: Config spec not present");
        } else {
            this.syncType(modid, type);
            this.notifyListeners(ConfigLoading.getState(evt));
            if (evt instanceof ModConfig.Reloading) {
                PuzzlesLib.LOGGER.info("Reloading " + type.extension() + " config for " + modid);
            }
        }
    }

    public void sync(String modid) {
        this.getEntriesForMod(modid).forEach(ConfigValueEntry::sync);
    }

    private void syncType(String modid, ModConfig.Type type) {
        this.getEntriesForMod(modid).filter(configValue -> configValue.getType() == type).forEach(ConfigValueEntry::sync);
    }

    private Stream<ConfigValueEntry<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getEntriesForMod(String modid) {
        return this.configEntries.values().stream().filter(entry -> entry.getModId().equals(modid));
    }

    public Object getValueFromPath(String ... paths) {
        return this.getValueFromPath(String.join((CharSequence)".", paths));
    }

    public Object getValueFromPath(String path) {
        Optional<Object> optional = Optional.ofNullable(this.configEntries.get(path)).map(ConfigValueEntry::getValue);
        if (optional.isPresent()) {
            return optional.get();
        }
        PuzzlesLib.LOGGER.error("Unable to get config value for path \"" + path + "\": Path not found");
        return Optional.empty();
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerCommonEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.COMMON, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerClientEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.CLIENT, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerServerEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.SERVER, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerEntry(S entry, Consumer<T> action) {
        this.registerEntry(entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void registerEntry(S entry, Consumer<R> action, Function<T, R> transformer) {
        ModConfig.Type activeType = this.getBuilder().getActiveType();
        if (activeType == null) {
            PuzzlesLib.LOGGER.error("Unable to register config entry: Active builder is null");
        } else if (this.getBuilder().isSpecNotBuilt(activeType)) {
            this.registerEntry(activeType, entry, action, transformer);
        } else {
            PuzzlesLib.LOGGER.error("Unable to register config entry: Config spec already built");
        }
    }

    private <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void registerEntry(ModConfig.Type type, S entry, Consumer<R> action, Function<T, R> transformer) {
        this.configEntries.put(String.join((CharSequence)".", entry.getPath()), new ConfigValueEntry<S, T, R>(type, entry, action, transformer, this.getActiveNamespace()));
    }

    public void addListener(Runnable listener) {
        this.addListener(listener, ConfigLoading.BOTH);
    }

    public void addLoadingListener(Runnable listener) {
        this.addListener(listener, ConfigLoading.LOADING);
    }

    public void addReloadingListener(Runnable listener) {
        this.addListener(listener, ConfigLoading.RELOADING);
    }

    private void addListener(Runnable listener, ConfigLoading state) {
        this.configListeners.merge(listener, state, (state1, state2) -> state1 != state2 ? ConfigLoading.BOTH : state1);
    }

    private void notifyListeners(ConfigLoading state) {
        this.configListeners.entrySet().stream().filter(entry -> ((ConfigLoading)((Object)((Object)entry.getValue()))).matches(state)).map(Map.Entry::getKey).forEach(Runnable::run);
    }

    public static String getConfigName(ModConfig.Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String getConfigNameInFolder(ModConfig.Type type, String modId) {
        return modId + File.separator + ConfigManager.getConfigName(type, modId);
    }

    @SafeVarargs
    public final <T extends IForgeRegistryEntry<T>> List<String> getKeyList(T ... entries) {
        return Stream.of(entries).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    private String getActiveNamespace() {
        return ModLoadingContext.get().getActiveNamespace();
    }

    private ConfigBuilder getBuilder() {
        return this.getBuilder(this.getActiveNamespace());
    }

    private ConfigBuilder getBuilder(String modid) {
        return this.configBuilders.computeIfAbsent(modid, key -> new ConfigBuilder());
    }

    public static ConfigManager get() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public static ConfigBuilder builder() {
        return ConfigManager.get().getBuilder();
    }

    private static enum ConfigLoading {
        LOADING,
        RELOADING,
        BOTH;


        boolean matches(ConfigLoading state) {
            if (state == BOTH || this == BOTH) {
                return true;
            }
            if (state == LOADING && this != RELOADING) {
                return true;
            }
            return state == RELOADING && this != LOADING;
        }

        static ConfigLoading getState(ModConfig.ModConfigEvent evt) {
            return evt instanceof ModConfig.Loading ? LOADING : RELOADING;
        }
    }
}

