/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.config;

import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

class ConfigTypeEntry {
    private final String type;
    private String path = "";
    private ForgeConfigSpec spec;
    private ForgeConfigSpec.Builder builder;

    ConfigTypeEntry(ModConfig.Type type) {
        this.type = type.extension();
    }

    boolean isSpecNotBuilt() {
        return this.spec == null;
    }

    boolean canBuildSpec() {
        return this.builder != null;
    }

    boolean addSpec(ForgeConfigSpec spec) {
        if (this.isSpecNotBuilt()) {
            this.spec = spec;
            return true;
        }
        return false;
    }

    @Nullable
    ForgeConfigSpec getSpec() {
        if (this.isSpecNotBuilt()) {
            if (!this.canBuildSpec()) {
                return null;
            }
            this.spec = this.builder.build();
        }
        return this.spec;
    }

    ForgeConfigSpec.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = new ForgeConfigSpec.Builder();
        }
        return this.builder;
    }

    void setPrefix(String prefix) {
        this.path = prefix;
    }

    String getName(ModLoadingContext context) {
        String modId = context.getActiveContainer().getModId();
        return this.path + String.format("%s-%s.toml", modId, this.type);
    }
}

