/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.config.json;

import com.fuzs.puzzleslib_ra.PuzzlesLib;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLPaths;

public class JSONConfigUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void load(String jsonName, BiConsumer<String, File> serializer, Consumer<FileReader> deserializer) {
        File jsonFile = JSONConfigUtil.getFilePath(jsonName);
        JSONConfigUtil.load(jsonName, jsonFile, serializer, deserializer);
    }

    public static void load(String jsonName, String modId, BiConsumer<String, File> serializer, Consumer<FileReader> deserializer) {
        File jsonFile = JSONConfigUtil.getFolderPath(jsonName, modId);
        JSONConfigUtil.load(jsonName, jsonFile, serializer, deserializer);
    }

    private static void load(String jsonName, File jsonFile, BiConsumer<String, File> serializer, Consumer<FileReader> deserializer) {
        JSONConfigUtil.createIfAbsent(jsonName, jsonFile, serializer);
        JSONConfigUtil.loadFromFile(jsonName, jsonFile, deserializer);
    }

    private static void createIfAbsent(String jsonName, File jsonFile, BiConsumer<String, File> serializer) {
        if (!jsonFile.exists()) {
            jsonFile.getParentFile().mkdir();
            serializer.accept(jsonName, jsonFile);
        }
    }

    public static void copyToFile(String jsonName, File jsonFile) {
        try (InputStream stream = JSONConfigUtil.class.getResourceAsStream(jsonName);){
            jsonFile.createNewFile();
            byte[] buffer = new byte[16384];
            FileOutputStream out = new FileOutputStream(jsonFile);
            int lengthRead = stream.read(buffer);
            if (lengthRead <= 0) {
                PuzzlesLib.LOGGER.error("Failed to copy {} in config directory: {}", (Object)jsonName, (Object)"Empty Buffer");
            }
            while (lengthRead > 0) {
                out.write(buffer, 0, lengthRead);
                out.flush();
                lengthRead = stream.read(buffer);
            }
            out.close();
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Failed to copy {} in config directory: {}", (Object)jsonName, (Object)e);
        }
    }

    public static void saveToFile(String jsonName, File jsonFile, JsonElement jsonElement) {
        try (FileWriter writer = new FileWriter(jsonFile);){
            GSON.toJson(jsonElement, (Appendable)writer);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Failed to create {} in config directory: {}", (Object)jsonName, (Object)e);
        }
    }

    private static void loadFromFile(String jsonName, File file, Consumer<FileReader> deserializer) {
        try (FileReader reader = new FileReader(file);){
            deserializer.accept(reader);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Failed to read {} in config directory: {}", (Object)jsonName, (Object)e);
        }
    }

    private static File getFilePath(String jsonName) {
        return new File(FMLPaths.CONFIGDIR.get().toFile(), jsonName);
    }

    private static File getFolderPath(String jsonName, String modId) {
        return new File(FMLPaths.CONFIGDIR.get().toFile(), modId + File.separator + jsonName);
    }
}

