/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.element;

import com.fuzs.puzzleslib_ra.config.ConfigManager;
import com.fuzs.puzzleslib_ra.element.EventListener;
import com.fuzs.puzzleslib_ra.element.IConfigurableElement;
import com.fuzs.puzzleslib_ra.element.registry.ElementRegistry;
import com.fuzs.puzzleslib_ra.element.side.IClientElement;
import com.fuzs.puzzleslib_ra.element.side.ICommonElement;
import com.fuzs.puzzleslib_ra.element.side.IServerElement;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractElement
extends EventListener
implements IConfigurableElement {
    private final List<EventListener.EventStorage<? extends Event>> events = Lists.newArrayList();
    private boolean enabled;

    private String getRegistryName() {
        return ElementRegistry.getRegistryName(this).func_110623_a();
    }

    @Override
    public final String getDisplayName() {
        return Stream.of(this.getRegistryName().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    @Override
    public boolean getDefaultState() {
        return true;
    }

    @Override
    public final void setupGeneralConfig(ForgeConfigSpec.Builder builder) {
        AbstractElement.addToConfig(builder.comment(this.getDescription()).define(this.getDisplayName(), this.getDefaultState()), this::setEnabled);
    }

    @Override
    public void unload() {
    }

    public final void setup() {
        this.setupConfig(this.getRegistryName());
        this.setupEvents();
    }

    private void setupConfig(String elementId) {
        Consumer<ICommonElement> commonConfig = element -> ConfigManager.builder().create(elementId, element::setupCommonConfig, ModConfig.Type.COMMON, element.getCommonDescription());
        Consumer<IClientElement> clientConfig = element -> ConfigManager.builder().create(elementId, element::setupClientConfig, ModConfig.Type.CLIENT, element.getClientDescription());
        Consumer<IServerElement> serverConfig = element -> ConfigManager.builder().create(elementId, element::setupServerConfig, ModConfig.Type.SERVER, element.getServerDescription());
        this.setupAllSides(commonConfig, clientConfig, serverConfig);
    }

    private void setupEvents() {
        this.setupAllSides(ICommonElement::setupCommon, IClientElement::setupClient, IServerElement::setupServer);
    }

    private void setupAllSides(Consumer<ICommonElement> commonSetup, Consumer<IClientElement> clientSetup, Consumer<IServerElement> serverSetup) {
        if (this instanceof ICommonElement) {
            commonSetup.accept((ICommonElement)((Object)this));
        }
        if (FMLEnvironment.dist.isClient() && this instanceof IClientElement) {
            clientSetup.accept((IClientElement)((Object)this));
        }
        if (FMLEnvironment.dist.isDedicatedServer() && this instanceof IServerElement) {
            serverSetup.accept((IServerElement)((Object)this));
        }
    }

    public final void load(ModLifecycleEvent evt) {
        this.loadEvents(evt);
        if (evt instanceof FMLCommonSetupEvent && this instanceof ICommonElement) {
            ((ICommonElement)((Object)this)).loadCommon();
        } else if (evt instanceof FMLClientSetupEvent && this instanceof IClientElement) {
            ((IClientElement)((Object)this)).loadClient();
        } else if (evt instanceof FMLDedicatedServerSetupEvent && this instanceof IServerElement) {
            ((IServerElement)((Object)this)).loadServer();
        }
    }

    private void loadEvents(ModLifecycleEvent evt) {
        if (this instanceof ICommonElement) {
            if (evt instanceof FMLCommonSetupEvent) {
                this.reload(true);
            }
        } else if (evt instanceof FMLClientSetupEvent || evt instanceof FMLDedicatedServerSetupEvent) {
            this.reload(true);
        }
    }

    private void reload(boolean isInit) {
        if (this.isEnabled() || this.isAlwaysEnabled()) {
            this.getEvents().forEach(EventListener.EventStorage::register);
        } else if (!isInit) {
            this.getEvents().forEach(EventListener.EventStorage::unregister);
            this.unload();
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAlwaysEnabled() {
        return false;
    }

    private void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.reload(false);
        }
    }

    @Override
    public final List<EventListener.EventStorage<? extends Event>> getEvents() {
        return this.events;
    }
}

