/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_ra.element;

import com.fuzs.puzzleslib_ra.config.ConfigManager;
import com.fuzs.puzzleslib_ra.config.deserialize.EntryCollectionBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class EventListener {
    public static <S extends ForgeConfigSpec.ConfigValue<T>, T> void addToConfig(S entry, Consumer<T> action) {
        ConfigManager.get().registerEntry(entry, action);
    }

    public static <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void addToConfig(S entry, Consumer<R> action, Function<T, R> transformer) {
        ConfigManager.get().registerEntry(entry, action, transformer);
    }

    public static <T extends IForgeRegistryEntry<T>> Set<T> deserializeToSet(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntrySet(data);
    }

    public static <T extends IForgeRegistryEntry<T>> Map<T, double[]> deserializeToMap(List<String> data, IForgeRegistry<T> registry) {
        return new EntryCollectionBuilder<T>(registry).buildEntryMap(data);
    }

    protected abstract List<EventStorage<? extends Event>> getEvents();

    protected final <T extends Event> void addListener(Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, consumer);
    }

    protected final <T extends Event> void addListener(boolean receiveCancelled, Consumer<T> consumer) {
        this.addListener(EventPriority.NORMAL, receiveCancelled, consumer);
    }

    protected final <T extends Event> void addListener(EventPriority priority, Consumer<T> consumer) {
        this.addListener(priority, false, consumer);
    }

    protected final <T extends Event> void addListener(EventPriority priority, boolean receiveCancelled, Consumer<T> consumer) {
        this.getEvents().add(new EventStorage(consumer, priority, receiveCancelled));
    }

    protected static class EventStorage<T extends Event> {
        private final Consumer<T> event;
        private final EventPriority priority;
        private final boolean receiveCancelled;
        private boolean active;

        private EventStorage(Consumer<T> consumer, EventPriority priority, boolean receiveCancelled) {
            this.event = consumer;
            this.priority = priority;
            this.receiveCancelled = receiveCancelled;
        }

        protected void register() {
            if (this.isActive(true)) {
                MinecraftForge.EVENT_BUS.addListener(this.priority, this.receiveCancelled, this.event);
            }
        }

        protected void unregister() {
            if (this.isActive(false)) {
                MinecraftForge.EVENT_BUS.unregister(this.event);
            }
        }

        private boolean isActive(boolean newState) {
            if (this.active != newState) {
                this.active = newState;
                return true;
            }
            return false;
        }
    }
}

