/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.respawnableanimals.common.element;

import com.fuzs.puzzleslib_ra.config.deserialize.EntryCollectionBuilder;
import com.fuzs.puzzleslib_ra.element.AbstractElement;
import com.fuzs.puzzleslib_ra.element.side.ICommonElement;
import com.fuzs.respawnableanimals.mixin.accessor.IBooleanValueAccessor;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class AnimalsElement
extends AbstractElement
implements ICommonElement {
    public static final GameRules.RuleKey<GameRules.BooleanValue> PERSISTENT_ANIMALS = GameRules.func_223595_a((String)"persistentAnimals", IBooleanValueAccessor.callCreate(false));
    public Set<EntityType<?>> animalBlacklist;
    public int maxAnimalNumber;
    public boolean summonedMobPersistence;

    @Override
    public String getDescription() {
        return "Animals are no longer persistent by default, making them spawn just like monsters.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onBabyEntitySpawn);
        this.addListener(this::onAnimalTame);
        this.addListener(this::onPotentialSpawns);
        this.addListener(this::onEntityJoinWorld);
        this.addListener(this::onCheckSpawn);
    }

    @Override
    public void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        AnimalsElement.addToConfig(builder.comment(new String[]{"Blacklist animals which will never despawn.", EntryCollectionBuilder.CONFIG_STRING}).define("Animal Blacklist", (Object)Lists.newArrayList()), v -> {
            this.animalBlacklist = v;
        }, v -> new EntryCollectionBuilder(ForgeRegistries.ENTITIES).buildEntrySet((List<String>)v));
        AnimalsElement.addToConfig(builder.comment("Constant for determining when to stop spawning animals in a world. Normally set to 10, monster constant is 70 for comparison. 18 is chosen to mimic spawning mechanics of the Beta era.").define("Animal Mob Cap", (Object)18), v -> {
            this.maxAnimalNumber = v;
        });
        AnimalsElement.addToConfig(builder.comment("Make all mobs (not just animals) automatically persistent when spawned using the \"/summon\" command, a spawn egg or a dispenser.").define("Summoned Mob Persistence", false), v -> {
            this.summonedMobPersistence = v;
        });
    }

    private void onBabyEntitySpawn(BabyEntitySpawnEvent evt) {
        if (evt.getChild() != null) {
            evt.getChild().func_110163_bv();
        }
    }

    private void onAnimalTame(AnimalTameEvent evt) {
        evt.getAnimal().func_110163_bv();
    }

    private void onPotentialSpawns(WorldEvent.PotentialSpawns evt) {
        evt.getList().removeIf(spawner -> this.animalBlacklist.contains(spawner.field_200702_b));
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof SkeletonHorseEntity && ((SkeletonHorseEntity)evt.getEntity()).func_190690_dh()) {
            ((SkeletonHorseEntity)evt.getEntity()).func_110163_bv();
        }
    }

    private void onCheckSpawn(LivingSpawnEvent.CheckSpawn evt) {
        if (!(evt.getWorld() instanceof World)) {
            return;
        }
        World world = (World)evt.getWorld();
        if (!(evt.getSpawnReason() != SpawnReason.CHUNK_GENERATION && evt.getSpawnReason() != SpawnReason.NATURAL || !(evt.getEntity() instanceof AnimalEntity) || evt.getEntity().func_200600_R().func_220339_d() != EntityClassification.CREATURE || world.func_82736_K().func_223586_b(PERSISTENT_ANIMALS) || this.animalBlacklist.contains(evt.getEntity().func_200600_R()))) {
            if (evt.getSpawnReason() == SpawnReason.CHUNK_GENERATION) {
                evt.setResult(Event.Result.DENY);
            } else {
                double distanceToClosestPlayer = this.getPlayerDistance(world, evt.getX(), evt.getY(), evt.getZ());
                if (!this.canSpawn(world, (MobEntity)evt.getEntity(), distanceToClosestPlayer)) {
                    evt.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private double getPlayerDistance(World world, double x, double y, double z) {
        PlayerEntity playerentity = world.func_217366_a(x, y, z, -1.0, false);
        assert (playerentity != null);
        return playerentity.func_70092_e(x, y, z);
    }

    private boolean canSpawn(World world, MobEntity entity, double distanceToClosestPlayer) {
        if (distanceToClosestPlayer > 16384.0 && AnimalsElement.canAnimalDespawn(this, entity, distanceToClosestPlayer)) {
            return false;
        }
        return entity.func_213380_a((IWorld)world, SpawnReason.NATURAL) && entity.func_205019_a((IWorldReader)world);
    }

    public static boolean canAnimalDespawn(AnimalsElement element, MobEntity entity, double distanceToClosestPlayer) {
        if (element.isEnabled() && !entity.field_70170_p.func_82736_K().func_223586_b(PERSISTENT_ANIMALS)) {
            return entity instanceof AnimalEntity && entity.func_200600_R().func_220339_d() == EntityClassification.CREATURE || entity.func_213397_c(distanceToClosestPlayer);
        }
        return entity.func_213397_c(distanceToClosestPlayer);
    }
}

