/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.respawnableanimals.mixin;

import com.fuzs.respawnableanimals.common.RespawnableAnimalsElements;
import com.fuzs.respawnableanimals.common.element.AnimalsElement;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEntity.class})
public abstract class MobEntityMixin
extends LivingEntity {
    protected MobEntityMixin(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Shadow
    public abstract void func_110163_bv();

    @Redirect(method={"checkDespawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/MobEntity;canDespawn(D)Z"))
    public boolean canAnimalDespawn(MobEntity entity, double distanceToClosestPlayer) {
        AnimalsElement element = (AnimalsElement)RespawnableAnimalsElements.getAs(RespawnableAnimalsElements.RESPAWNABLE_ANIMALS);
        return AnimalsElement.canAnimalDespawn(element, entity, distanceToClosestPlayer);
    }

    @Inject(method={"preventDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    public void preventDespawn(CallbackInfoReturnable<Boolean> callbackInfo) {
        AnimalsElement element = (AnimalsElement)RespawnableAnimalsElements.getAs(RespawnableAnimalsElements.RESPAWNABLE_ANIMALS);
        MobEntity entity = (MobEntity)this;
        if (element.isEnabled() && !this.field_70170_p.func_82736_K().func_223586_b(AnimalsElement.PERSISTENT_ANIMALS) && entity instanceof AnimalEntity && element.animalBlacklist.contains(entity.func_200600_R()) && MobEntityMixin.canDespawnBePrevented(entity)) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    @Unique
    private static boolean canDespawnBePrevented(MobEntity entity) {
        PlayerEntity closestPlayer = entity.field_70170_p.func_217362_a((Entity)entity, -1.0);
        if (closestPlayer != null) {
            double distanceToPlayer = entity.func_70068_e((Entity)entity);
            return !entity.func_213397_c(distanceToPlayer);
        }
        return true;
    }

    @Inject(method={"onInitialSpawn"}, at={@At(value="HEAD")})
    public void onInitialSpawn(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag, CallbackInfoReturnable<ILivingEntityData> callbackInfo) {
        AnimalsElement element = (AnimalsElement)RespawnableAnimalsElements.getAs(RespawnableAnimalsElements.RESPAWNABLE_ANIMALS);
        if (element.isEnabled() && element.summonedMobPersistence && (reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.DISPENSER)) {
            this.func_110163_bv();
        }
    }
}

