/*
 * Decompiled with CFR 0.152.
 */
package fuzs.respawnableanimals.element;

import fuzs.puzzleslib.config.option.OptionsBuilder;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import fuzs.puzzleslib.element.AbstractElement;
import fuzs.puzzleslib.element.side.ICommonElement;
import fuzs.puzzleslib.util.LoadedLocationList;
import fuzs.puzzleslib.util.PuzzlesUtil;
import fuzs.respawnableanimals.mixin.accessor.BooleanValueAccessor;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RespawnableAnimalsElement
extends AbstractElement
implements ICommonElement {
    public static final GameRules.RuleKey<GameRules.BooleanValue> PERSISTENT_ANIMALS = GameRules.func_234903_a_((String)"persistentAnimals", (GameRules.Category)GameRules.Category.SPAWNING, BooleanValueAccessor.callCreate(false));
    public Set<EntityType<?>> animalBlacklist;
    public int maxAnimalNumber;
    public boolean summonedMobPersistence;

    public String[] getDescription() {
        return new String[]{"Animals are no longer persistent by default, making them spawn just like monsters."};
    }

    protected boolean isPersistent() {
        return true;
    }

    public void constructCommon() {
        this.addListener(this::onBabyEntitySpawn, EventPriority.LOW);
        this.addListener(this::onAnimalTame);
        this.addListener(this::onPotentialSpawns);
        this.addListener(this::onEntityJoinWorld);
        this.addListener(this::onCheckSpawn);
    }

    public void setupCommonConfig(OptionsBuilder builder) {
        builder.define("Animal Blacklist", (List)PuzzlesUtil.make((Object)new LoadedLocationList(), list -> list.add(new ResourceLocation("whisperwoods", "hirschgeist")))).comment(new String[]{"Blacklist animals which will never despawn.", EntryCollectionBuilder.CONFIG_STRING}).sync(v -> {
            this.animalBlacklist = new EntryCollectionBuilder(ForgeRegistries.ENTITIES).buildEntrySet(v);
        });
        builder.define("Animal Mob Cap", 18).comment(new String[]{"Constant for determining when to stop spawning animals in a world. Normally set to 10, monster constant is 70 for comparison. 18 is chosen to mimic spawning mechanics of the Beta era."}).sync(v -> {
            this.maxAnimalNumber = v;
        });
        builder.define("Summoned Mob Persistence", false).comment(new String[]{"Make all mobs (not just animals) automatically persistent when spawned using the \"/summon\" command, a spawn egg or a dispenser."}).sync(v -> {
            this.summonedMobPersistence = v;
        });
    }

    private void onBabyEntitySpawn(BabyEntitySpawnEvent evt) {
        MobEntity parent;
        if (evt.getChild() != null) {
            evt.getChild().func_110163_bv();
        }
        if (ModList.get().isLoaded("environmental") && (parent = evt.getParentA()) instanceof PigEntity && evt.getParentB() instanceof PigEntity) {
            parent.field_70170_p.func_175647_a(PigEntity.class, parent.func_174813_aQ(), AgeableEntity::func_70631_g_).forEach(MobEntity::func_110163_bv);
        }
    }

    private void onAnimalTame(AnimalTameEvent evt) {
        evt.getAnimal().func_110163_bv();
    }

    private void onPotentialSpawns(WorldEvent.PotentialSpawns evt) {
        evt.getList().removeIf(spawner -> this.animalBlacklist.contains(spawner.field_242588_c));
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof SkeletonHorseEntity && ((SkeletonHorseEntity)evt.getEntity()).func_190690_dh()) {
            ((SkeletonHorseEntity)evt.getEntity()).func_110163_bv();
        }
    }

    private void onCheckSpawn(LivingSpawnEvent.CheckSpawn evt) {
        if (!(evt.getWorld() instanceof IServerWorld)) {
            return;
        }
        ServerWorld serverWorld = ((IServerWorld)evt.getWorld()).func_201672_e();
        if (!(evt.getSpawnReason() != SpawnReason.CHUNK_GENERATION && evt.getSpawnReason() != SpawnReason.NATURAL || !(evt.getEntity() instanceof AnimalEntity) || evt.getEntity().func_200600_R().func_220339_d() != EntityClassification.CREATURE || serverWorld.func_82736_K().func_223586_b(PERSISTENT_ANIMALS) || this.animalBlacklist.contains(evt.getEntity().func_200600_R()))) {
            if (evt.getSpawnReason() == SpawnReason.CHUNK_GENERATION) {
                evt.setResult(Event.Result.DENY);
            } else {
                double distanceToClosestPlayer = this.getPlayerDistance(serverWorld, evt.getX(), evt.getY(), evt.getZ());
                if (!this.canSpawn(serverWorld, (MobEntity)evt.getEntity(), distanceToClosestPlayer)) {
                    evt.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private double getPlayerDistance(ServerWorld serverWorld, double x, double y, double z) {
        return serverWorld.func_217366_a(x, y, z, -1.0, false).func_70092_e(x, y, z);
    }

    private boolean canSpawn(ServerWorld serverWorld, MobEntity entity, double distanceToClosestPlayer) {
        if (distanceToClosestPlayer > (double)(entity.func_200600_R().func_220339_d().func_233671_f_() * entity.func_200600_R().func_220339_d().func_233671_f_()) && RespawnableAnimalsElement.canAnimalDespawn(entity, distanceToClosestPlayer)) {
            return false;
        }
        return entity.func_213380_a((IWorld)serverWorld, SpawnReason.NATURAL) && entity.func_205019_a((IWorldReader)serverWorld);
    }

    public static boolean canAnimalDespawn(MobEntity entity, double distanceToClosestPlayer) {
        if (!entity.field_70170_p.func_82736_K().func_223586_b(PERSISTENT_ANIMALS)) {
            return entity instanceof AnimalEntity && entity.func_200600_R().func_220339_d() == EntityClassification.CREATURE && (!(entity instanceof TameableEntity) || !((TameableEntity)entity).func_70909_n()) || entity.func_213397_c(distanceToClosestPlayer);
        }
        return entity.func_213397_c(distanceToClosestPlayer);
    }
}

