/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.mixin;

import baguchan.revampedwolf.api.IHasArmor;
import baguchan.revampedwolf.api.IHasInventory;
import baguchan.revampedwolf.api.IHunger;
import baguchan.revampedwolf.api.IHunt;
import baguchan.revampedwolf.api.IOpenWolfContainer;
import baguchan.revampedwolf.entity.goal.HuntTargetGoal;
import baguchan.revampedwolf.entity.goal.MoveToMeatGoal;
import baguchan.revampedwolf.entity.goal.WolfAvoidEntityGoal;
import baguchan.revampedwolf.item.WolfArmorItem;
import com.google.common.collect.Lists;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends TamableAnimal
implements NeutralMob,
IHunt,
IHunger,
IHasArmor,
IHasInventory,
ContainerListener {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final UUID TOUGHNESS_ARMOR_MODIFIER_UUID = UUID.fromString("db9bf914-5933-474e-a184-e73040fb0789");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("7c036153-7d05-c9e5-2f29-c664ef413677");
    private int huntCooldown;
    private int eatTick;
    private int hungerTick;
    @Shadow
    @Final
    public static Predicate<LivingEntity> f_30357_;
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;

    protected WolfMixin(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onConstructor(EntityType<? extends Wolf> p_27557_, Level p_27558_, CallbackInfo info) {
        this.m_21553_(true);
        this.createInventory();
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")}, cancellable=true)
    protected void registerGoals(CallbackInfo callbackInfo) {
        Wolf wolf = (Wolf)this;
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, new WolfAvoidEntityGoal<Llama>(wolf, Llama.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new MoveToMeatGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new BegGoal(wolf, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WolfMixin)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, new HuntTargetGoal<Animal>(this, Animal.class, false, f_30357_));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        callbackInfo.cancel();
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player p_30412_, InteractionHand p_30413_, CallbackInfoReturnable<InteractionResult> callbackInfo) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        Item item = itemstack.m_41720_();
        if (p_30412_.m_36341_() && this.m_21824_() && this.m_21830_((LivingEntity)p_30412_) && p_30412_ instanceof IOpenWolfContainer) {
            this.openInventory(p_30412_);
            this.m_146850_(GameEvent.f_223708_);
            callbackInfo.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    public void openInventory(Player player) {
        Wolf wolf = (Wolf)this;
        if (!this.f_19853_.f_46443_ && player instanceof IOpenWolfContainer) {
            ((IOpenWolfContainer)player).openWolfInventory(wolf, (Container)this.inventory);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void aiStep(CallbackInfo callbackInfo) {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.hungerTick > 0) {
                --this.hungerTick;
            }
            ItemStack mainhand = this.m_21120_(InteractionHand.MAIN_HAND);
            if (!this.m_6117_() && this.m_21120_(InteractionHand.MAIN_HAND).m_41720_().m_41473_() != null && this.m_21120_(InteractionHand.MAIN_HAND).m_41720_().m_41473_().m_38746_()) {
                ++this.eatTick;
                if (this.eatTick > 300 && !mainhand.m_41619_()) {
                    this.m_6672_(InteractionHand.MAIN_HAND);
                }
            } else {
                this.eatTick = 0;
            }
        }
    }

    protected void m_8095_() {
        ItemStack copy;
        InteractionHand hand = this.m_7655_();
        if (this.f_20935_.equals(this.m_21120_(hand)) && !this.f_20935_.m_41619_() && this.m_6117_() && (copy = this.f_20935_.m_41777_()).m_41720_().m_41473_() != null) {
            this.m_5634_(copy.m_41720_().m_41473_().m_38744_());
        }
        super.m_8095_();
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, p_28602_);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), p_28606_);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    public boolean m_7252_(ItemStack p_28578_) {
        Item item = p_28578_.m_41720_();
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && item.m_41472_() && item.m_41473_().m_38746_();
    }

    protected void m_7581_(ItemEntity p_28514_) {
        ItemStack itemstack;
        if (!this.m_21824_() && this.m_7252_(itemstack = p_28514_.m_32055_())) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.dropItemStack(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_21053_(p_28514_);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)p_28514_, itemstack.m_41613_());
            p_28514_.m_146870_();
            this.eatTick = 0;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void addAdditionalSaveData(CompoundTag p_213281_1_, CallbackInfo callbackInfo) {
        p_213281_1_.m_128405_("HuntingCooldown", this.huntCooldown);
        p_213281_1_.m_128405_("EatTick", this.eatTick);
        p_213281_1_.m_128405_("HungerTick", this.hungerTick);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            p_213281_1_.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void readAdditionalSaveData(CompoundTag p_70037_1_, CallbackInfo callbackInfo) {
        ItemStack itemstack;
        this.huntCooldown = p_70037_1_.m_128451_("HuntingCooldown");
        this.eatTick = p_70037_1_.m_128451_("EatTick");
        this.hungerTick = p_70037_1_.m_128451_("HungerTick");
        if (p_70037_1_.m_128425_("ArmorItem", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)p_70037_1_.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemstack)) {
            this.inventory.m_6836_(0, itemstack);
        }
        this.updateContainerEquipment();
        this.m_21553_(true);
    }

    public boolean m_214076_(ServerLevel p_216988_, LivingEntity p_216989_) {
        this.setHuntCooldown(1200);
        return super.m_214076_(p_216988_, p_216989_);
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private int getInventorySize() {
        return 1;
    }

    private void updateContainerEquipment() {
        if (!this.f_19853_.f_46443_) {
            this.m_8061_(EquipmentSlot.CHEST, this.inventory.m_8020_(0));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
            ItemStack stack = this.inventory.m_8020_(0);
            AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
            if (this.isArmor(stack)) {
                AttributeInstance knockback_resistance;
                AttributeInstance toughness;
                if (armor != null) {
                    armor.m_22120_(ARMOR_MODIFIER_UUID);
                    int i = ((WolfArmorItem)stack.m_41720_()).getDefense();
                    if (i != 0) {
                        armor.m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Wolf armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
                    }
                }
                if ((toughness = this.m_21051_(Attributes.f_22285_)) != null) {
                    toughness.m_22120_(TOUGHNESS_ARMOR_MODIFIER_UUID);
                    float i = ((WolfArmorItem)stack.m_41720_()).getToughness();
                    if (i != 0.0f) {
                        toughness.m_22118_(new AttributeModifier(TOUGHNESS_ARMOR_MODIFIER_UUID, "Wolf Toughness armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
                    }
                }
                if ((knockback_resistance = this.m_21051_(Attributes.f_22278_)) != null) {
                    knockback_resistance.m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
                    float i = ((WolfArmorItem)stack.m_41720_()).getToughness();
                    if (i != 0.0f) {
                        knockback_resistance.m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Wolf KnockBack Resistance bonus", (double)i, AttributeModifier.Operation.ADDITION));
                    }
                }
            }
        }
    }

    public SlotAccess m_141942_(int p_149743_) {
        int i = p_149743_ - 300;
        return i >= 0 && i < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)i) : super.m_141942_(p_149743_);
    }

    @Override
    public void setHuntCooldown(int cooldown) {
        this.huntCooldown = cooldown;
    }

    @Override
    public int getHuntCooldown() {
        return this.huntCooldown;
    }

    @Override
    public boolean isHunted() {
        return this.huntCooldown > 0;
    }

    @Override
    public int getHunger() {
        return this.hungerTick;
    }

    @Override
    public void setHunger(int hunger) {
        this.hungerTick = hunger;
    }

    @Override
    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    @Override
    public boolean isArmor(ItemStack p_30645_) {
        return p_30645_.m_41720_() instanceof WolfArmorItem;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public Iterable<ItemStack> m_6168_() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.inventory.m_8020_(0)});
    }

    public ItemStack m_6844_(EquipmentSlot p_21467_) {
        switch (p_21467_.m_20743_()) {
            case ARMOR: {
                return this.inventory.m_8020_(0);
            }
        }
        return super.m_6844_(p_21467_);
    }

    public void m_8061_(EquipmentSlot p_21416_, ItemStack p_21417_) {
        this.m_181122_(p_21417_);
        switch (p_21416_.m_20743_()) {
            case HAND: {
                super.m_8061_(p_21416_, p_21417_);
                break;
            }
            case ARMOR: {
                this.inventory.m_6836_(0, p_21417_);
            }
        }
    }

    @Override
    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    @Override
    public SimpleContainer getContainer() {
        return this.inventory;
    }

    public void m_5757_(Container p_18983_) {
        ItemStack itemstack = this.getArmor();
        ItemStack itemstack1 = this.getArmor();
        if (this.f_19797_ > 20 && this.isArmor(itemstack1) && itemstack != itemstack1) {
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            this.updateContainerEquipment();
        }
    }
}

