/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.BagusLib;
import bagu_chan.bagus_lib.api.IBaguPacket;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class SyncEntityPacketToServer
implements CustomPacketPayload {
    public static final ResourceLocation ID = BagusLib.prefix("sync_packet");
    private final UUID uuid;

    public SyncEntityPacketToServer(UUID uuid) {
        this.uuid = uuid;
    }

    public SyncEntityPacketToServer(FriendlyByteBuf buf) {
        this(buf.readUUID());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(SyncEntityPacketToServer message, PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Entity entity;
            Optional player = context.player();
            if (player.isPresent() && (entity = ((ServerLevel)((Player)player.get()).level()).getEntity(message.uuid)) instanceof IBaguPacket) {
                IBaguPacket baguPacket = (IBaguPacket)entity;
                baguPacket.resync(entity);
            }
        });
    }
}

