/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.mixin;

import bagu_chan.bagus_lib.api.IBaguPacket;
import baguchan.revampedwolf.api.IHasArmor;
import baguchan.revampedwolf.api.IHasInventory;
import baguchan.revampedwolf.api.IHunger;
import baguchan.revampedwolf.api.IHunt;
import baguchan.revampedwolf.api.IOpenWolfContainer;
import baguchan.revampedwolf.api.IWolfTypes;
import baguchan.revampedwolf.api.WolfTypes;
import baguchan.revampedwolf.entity.goal.HuntTargetGoal;
import baguchan.revampedwolf.entity.goal.MoveToMeatGoal;
import baguchan.revampedwolf.entity.goal.WolfAvoidEntityGoal;
import baguchan.revampedwolf.inventory.WolfInventoryMenu;
import baguchan.revampedwolf.item.WolfArmorItem;
import baguchan.revampedwolf.network.ClientWolfScreenOpenPacket;
import baguchan.revampedwolf.network.WolfVariantPacket;
import com.google.common.collect.Lists;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends TamableAnimal
implements NeutralMob,
IHunt,
IHunger,
IHasArmor,
IHasInventory,
IWolfTypes,
ContainerListener,
IBaguPacket {
    private String variant;
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final UUID TOUGHNESS_ARMOR_MODIFIER_UUID = UUID.fromString("db9bf914-5933-474e-a184-e73040fb0789");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("7c036153-7d05-c9e5-2f29-c664ef413677");
    private int huntCooldown;
    private int eatTick;
    private int hungerTick;
    private float saturation;
    @Shadow
    @Final
    public static Predicate<LivingEntity> PREY_SELECTOR;
    protected SimpleContainer inventory;

    protected WolfMixin(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.variant = WolfTypes.WHITE.type;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onConstructor(EntityType<? extends Wolf> p_27557_, Level p_27558_, CallbackInfo info) {
        this.setCanPickUpLoot(true);
        this.createInventory();
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")}, cancellable=true)
    protected void registerGoals(CallbackInfo callbackInfo) {
        Wolf wolf = (Wolf)this;
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Llama>(wolf, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new MoveToMeatGoal(this));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new BegGoal(wolf, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WolfMixin)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, new HuntTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        callbackInfo.cancel();
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player p_30412_, InteractionHand p_30413_, CallbackInfoReturnable<InteractionResult> callbackInfo) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (p_30412_.isSecondaryUseActive() && this.isTame() && this.isOwnedBy((LivingEntity)p_30412_) && p_30412_ instanceof IOpenWolfContainer) {
            this.openInventory(p_30412_);
            this.gameEvent(GameEvent.ENTITY_INTERACT);
            callbackInfo.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Wolf;heal(F)V", shift=At.Shift.AFTER, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void mobInteractHeal(Player p_30412_, InteractionHand p_30413_, CallbackInfoReturnable<InteractionResult> cir, ItemStack itemstack) {
        this.saturation = Mth.clamp((float)(this.saturation + (float)itemstack.getItem().getFoodProperties().getNutrition() * itemstack.getItem().getFoodProperties().getSaturationModifier() * 2.0f), (float)0.0f, (float)20.0f);
    }

    public void openInventory(Player player) {
        Wolf wolf = (Wolf)this;
        if (!this.level().isClientSide && player instanceof IOpenWolfContainer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.containerMenu != sp.inventoryMenu) {
                sp.closeContainer();
            }
            sp.nextContainerCounter();
            PacketDistributor.PLAYER.with((Object)sp).send(new CustomPacketPayload[]{new ClientWolfScreenOpenPacket(sp.containerCounter, this.getId())});
            sp.containerMenu = new WolfInventoryMenu(sp.containerCounter, sp.getInventory(), (Container)this.inventory, wolf);
            sp.initMenu(sp.containerMenu);
            NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.containerMenu));
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void aiStep(CallbackInfo callbackInfo) {
        if (!this.level().isClientSide && this.isAlive()) {
            if (this.hungerTick > 0) {
                --this.hungerTick;
            }
            ItemStack mainhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isUsingItem() && this.getItemInHand(InteractionHand.MAIN_HAND).getItem().getFoodProperties() != null && this.getItemInHand(InteractionHand.MAIN_HAND).getItem().getFoodProperties().isMeat()) {
                if (this.getHealth() < this.getMaxHealth() || !this.isTame()) {
                    ++this.eatTick;
                    if (this.eatTick > 200 && !mainhand.isEmpty()) {
                        this.startUsingItem(InteractionHand.MAIN_HAND);
                    }
                }
            } else {
                this.eatTick = 0;
            }
        }
        if (this.getHealth() < this.getMaxHealth() && this.saturation > 0.0f) {
            this.saturation = Mth.clamp((float)(this.saturation - 0.5f), (float)0.0f, (float)20.0f);
            if (this.saturation >= 0.5f) {
                this.heal(1.0f);
            }
        }
    }

    protected void completeUsingItem() {
        ItemStack copy;
        InteractionHand hand = this.getUsedItemHand();
        if (this.useItem.equals(this.getItemInHand(hand)) && !this.useItem.isEmpty() && this.isUsingItem() && (copy = this.useItem.copy()).getItem().getFoodProperties() != null) {
            this.heal(copy.getItem().getFoodProperties().getNutrition());
            this.saturation = Mth.clamp((float)(this.saturation + (float)copy.getItem().getFoodProperties().getNutrition() * copy.getItem().getFoodProperties().getSaturationModifier() * 2.0f), (float)0.0f, (float)20.0f);
        }
        super.completeUsingItem();
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.isEmpty() && !this.level().isClientSide) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity((Entity)itementity);
    }

    public boolean canHoldItem(ItemStack p_28578_) {
        Item item = p_28578_.getItem();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() && item.isEdible() && item.getFoodProperties().isMeat();
    }

    protected void pickUpItem(ItemEntity p_28514_) {
        ItemStack itemstack;
        if (!this.isTame() && this.canHoldItem(itemstack = p_28514_.getItem())) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 2.0f;
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.eatTick = 0;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void addAdditionalSaveData(CompoundTag p_213281_1_, CallbackInfo callbackInfo) {
        p_213281_1_.putString("Type", this.getVariant().getSerializedName());
        p_213281_1_.putInt("HuntingCooldown", this.huntCooldown);
        p_213281_1_.putInt("EatTick", this.eatTick);
        p_213281_1_.putInt("HungerTick", this.hungerTick);
        if (!this.inventory.getItem(0).isEmpty()) {
            p_213281_1_.put("ArmorItem", (Tag)this.inventory.getItem(0).save(new CompoundTag()));
        }
        if (!this.inventory.getItem(1).isEmpty()) {
            p_213281_1_.put("OffHandWolfItem", (Tag)this.inventory.getItem(1).save(new CompoundTag()));
        }
        if (!this.inventory.getItem(2).isEmpty()) {
            p_213281_1_.put("MainHandWolfItem", (Tag)this.inventory.getItem(2).save(new CompoundTag()));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void readAdditionalSaveData(CompoundTag p_70037_1_, CallbackInfo callbackInfo) {
        ItemStack itemstack;
        this.setVariant(WolfTypes.byType(p_70037_1_.getString("Type")));
        this.huntCooldown = p_70037_1_.getInt("HuntingCooldown");
        this.eatTick = p_70037_1_.getInt("EatTick");
        this.hungerTick = p_70037_1_.getInt("HungerTick");
        if (p_70037_1_.contains("ArmorItem", 10) && !(itemstack = ItemStack.of((CompoundTag)p_70037_1_.getCompound("ArmorItem"))).isEmpty() && this.isArmor(itemstack)) {
            this.inventory.setItem(0, itemstack);
        }
        if (p_70037_1_.contains("OffHandWolfItem", 10) && !(itemstack = ItemStack.of((CompoundTag)p_70037_1_.getCompound("OffHandWolfItem"))).isEmpty()) {
            this.inventory.setItem(1, itemstack);
        }
        if (p_70037_1_.contains("MainHandWolfItem", 10) && !(itemstack = ItemStack.of((CompoundTag)p_70037_1_.getCompound("MainHandWolfItem"))).isEmpty()) {
            this.inventory.setItem(2, itemstack);
        }
        this.updateContainerEquipment();
        this.setCanPickUpLoot(true);
    }

    public boolean killedEntity(ServerLevel p_216988_, LivingEntity p_216989_) {
        this.setHuntCooldown(1200);
        return super.killedEntity(p_216988_, p_216989_);
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.removeListener((ContainerListener)this);
            int i = Math.min(simplecontainer.getContainerSize(), this.inventory.getContainerSize());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.getItem(j);
                if (itemstack.isEmpty()) continue;
                this.inventory.setItem(j, itemstack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack)) continue;
                this.spawnAtLocation(itemstack);
            }
        }
    }

    private int getInventorySize() {
        return 3;
    }

    private void updateContainerEquipment() {
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        if (!this.level().isClientSide) {
            this.setDropChance(EquipmentSlot.CHEST, 0.0f);
            ItemStack stack = this.inventory.getItem(0);
            if (this.isArmor(stack)) {
                AttributeInstance knockback_resistance;
                AttributeInstance toughness;
                AttributeInstance armor = this.getAttribute(Attributes.ARMOR);
                if (armor != null) {
                    armor.removeModifier(ARMOR_MODIFIER_UUID);
                    int i = ((WolfArmorItem)stack.getItem()).getDefense();
                    if (i != 0) {
                        armor.addTransientModifier(new AttributeModifier(ARMOR_MODIFIER_UUID, "Wolf armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
                    }
                }
                if ((toughness = this.getAttribute(Attributes.ARMOR_TOUGHNESS)) != null) {
                    toughness.removeModifier(TOUGHNESS_ARMOR_MODIFIER_UUID);
                    float i = ((WolfArmorItem)stack.getItem()).getToughness();
                    if (i != 0.0f) {
                        toughness.addTransientModifier(new AttributeModifier(TOUGHNESS_ARMOR_MODIFIER_UUID, "Wolf Toughness armor bonus", (double)i, AttributeModifier.Operation.ADDITION));
                    }
                }
                if ((knockback_resistance = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE)) != null) {
                    knockback_resistance.removeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
                    float i = ((WolfArmorItem)stack.getItem()).getToughness();
                    if (i != 0.0f) {
                        knockback_resistance.addTransientModifier(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Wolf KnockBack Resistance bonus", (double)i, AttributeModifier.Operation.ADDITION));
                    }
                }
            }
        }
    }

    public SlotAccess getSlot(int p_149743_) {
        int i = p_149743_ - 300;
        return i >= 0 && i < this.inventory.getContainerSize() ? SlotAccess.forContainer((Container)this.inventory, (int)i) : super.getSlot(p_149743_);
    }

    @Override
    public void setHuntCooldown(int cooldown) {
        this.huntCooldown = cooldown;
    }

    @Override
    public int getHuntCooldown() {
        return this.huntCooldown;
    }

    @Override
    public boolean isHunted() {
        return this.huntCooldown > 0;
    }

    @Override
    public int getHunger() {
        return this.hungerTick;
    }

    @Override
    public void setHunger(int hunger) {
        this.hungerTick = hunger;
    }

    @Override
    public boolean isWearingArmor() {
        return !this.getItemBySlot(EquipmentSlot.CHEST).isEmpty();
    }

    @Override
    public boolean isArmor(ItemStack p_30645_) {
        return p_30645_.getItem() instanceof WolfArmorItem;
    }

    @Override
    public ItemStack getArmor() {
        return this.getItemBySlot(EquipmentSlot.CHEST);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.inventory.getItem(0)});
    }

    public Iterable<ItemStack> getHandSlots() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.inventory.getItem(1), this.inventory.getItem(2)});
    }

    public ItemStack getItemBySlot(EquipmentSlot p_21467_) {
        if (p_21467_ == EquipmentSlot.OFFHAND) {
            return this.inventory.getItem(1);
        }
        if (p_21467_ == EquipmentSlot.MAINHAND) {
            return this.inventory.getItem(2);
        }
        switch (p_21467_.getType()) {
            case ARMOR: {
                return this.inventory.getItem(0);
            }
        }
        return super.getItemBySlot(p_21467_);
    }

    public void setItemSlot(EquipmentSlot p_21416_, ItemStack p_21417_) {
        this.verifyEquippedItem(p_21417_);
        switch (p_21416_.getType()) {
            case HAND: {
                if (p_21416_ == EquipmentSlot.OFFHAND) {
                    this.inventory.setItem(1, p_21417_);
                    break;
                }
                if (p_21416_ == EquipmentSlot.MAINHAND) {
                    this.inventory.setItem(2, p_21417_);
                    break;
                }
                super.setItemSlot(p_21416_, p_21417_);
                break;
            }
            case ARMOR: {
                this.inventory.setItem(0, p_21417_);
            }
        }
    }

    @Override
    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    @Override
    public SimpleContainer getContainer() {
        return this.inventory;
    }

    public void containerChanged(Container p_18983_) {
        this.updateContainerEquipment();
        ItemStack itemstack = this.getArmor();
        if (this.tickCount > 20 && this.isArmor(itemstack)) {
            this.playSound(SoundEvents.ARMOR_EQUIP_GENERIC, 1.0f, 1.0f);
        }
    }

    @Override
    public void setVariant(WolfTypes p_28929_) {
        this.variant = p_28929_.type;
        this.resync((Entity)this);
    }

    @Override
    public WolfTypes getVariant() {
        return WolfTypes.byType(this.variant);
    }

    public void resync(Entity entity) {
        if (!this.level().isClientSide()) {
            PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity).send(new CustomPacketPayload[]{new WolfVariantPacket(entity.getId(), this.variant)});
        }
    }

    @Inject(method={"getBreedOffspring"}, at={@At(value="RETURN")})
    public Wolf getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_, CallbackInfoReturnable<Wolf> ci) {
        Wolf wolf = (Wolf)ci.getReturnValue();
        ((IWolfTypes)wolf).setVariant(this.getOffspringType((Wolf)p_146744_));
        return wolf;
    }

    private WolfTypes getOffspringType(Wolf p_28931_) {
        WolfTypes type = this.getVariant();
        WolfTypes type1 = ((IWolfTypes)p_28931_).getVariant();
        WolfTypes type2 = this.random.nextBoolean() ? type : type1;
        return type2;
    }
}

