/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;

public abstract class BagusModelEvent
extends Event {
    private LivingEntity entityIn;
    private EntityModel model;
    private float partialTick;

    public BagusModelEvent(LivingEntity entityIn, EntityModel model, float partialTick) {
        this.entityIn = entityIn;
        this.model = model;
        this.partialTick = partialTick;
    }

    public Entity getEntity() {
        return this.entityIn;
    }

    public EntityModel getModel() {
        return this.model;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public static class PostAnimate
    extends BagusModelEvent {
        public PostAnimate(LivingEntity entityIn, EntityModel model, float partialTick) {
            super(entityIn, model, partialTick);
        }

        public float getAgeInTick() {
            return this.getPartialTick() + (float)this.getEntity().tickCount;
        }
    }

    public static class PreAnimate
    extends BagusModelEvent {
        public PreAnimate(LivingEntity entityIn, EntityModel model, float partialTick) {
            super(entityIn, model, partialTick);
        }

        public float getAgeInTick() {
            return this.getPartialTick() + (float)this.getEntity().tickCount;
        }
    }

    public static class Init
    extends BagusModelEvent {
        public Init(LivingEntity entityIn, EntityModel model, float partialTick) {
            super(entityIn, model, partialTick);
        }
    }

    public static class Scale
    extends BagusModelEvent {
        private PoseStack poseStack;

        public Scale(LivingEntity entityIn, EntityModel model, float partialTick, PoseStack poseStack) {
            super(entityIn, model, partialTick);
            this.poseStack = poseStack;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }
    }
}

