/*
 * Decompiled with CFR 0.152.
 */
package baguchan.revampedwolf.mixin;

import baguchan.revampedwolf.api.IHunger;
import baguchan.revampedwolf.api.IHunt;
import baguchan.revampedwolf.entity.goal.HuntTargetGoal;
import baguchan.revampedwolf.entity.goal.MoveToMeatGoal;
import baguchan.revampedwolf.entity.goal.WolfAvoidEntityGoal;
import baguchan.revampedwolf.item.RevampedWolfArmorItem;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Wolf.class})
public abstract class WolfMixin
extends TamableAnimal
implements NeutralMob,
IHunt,
IHunger {
    private int huntCooldown;
    private int eatTick;
    private int hungerTick;
    private float saturation;
    @Shadow
    @Final
    public static Predicate<LivingEntity> PREY_SELECTOR;

    @Shadow
    public abstract boolean hasArmor();

    protected WolfMixin(EntityType<? extends TamableAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onConstructor(EntityType<? extends Wolf> p_27557_, Level p_27558_, CallbackInfo info) {
        this.setCanPickUpLoot(true);
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")}, cancellable=true)
    protected void registerGoals(CallbackInfo callbackInfo) {
        Wolf wolf = (Wolf)this;
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal((TamableAnimal)this, 1.5, DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Llama>(wolf, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new MoveToMeatGoal(this));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new BegGoal(wolf, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WolfMixin)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, new HuntTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        callbackInfo.cancel();
    }

    @Inject(method={"canArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void canArmorAbsorb(DamageSource p_331524_, CallbackInfoReturnable<Boolean> cir) {
        if (this.getBodyArmorItem().getItem() instanceof RevampedWolfArmorItem) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player p_30412_, InteractionHand p_30413_, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (!this.level().isClientSide && itemstack.getItem() instanceof RevampedWolfArmorItem && this.isOwnedBy((LivingEntity)p_30412_) && !this.hasArmor() && !this.isBaby()) {
            this.setBodyArmorItem(itemstack.copyWithCount(1));
            itemstack.consume(1, (LivingEntity)p_30412_);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Inject(method={"hasArmor"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasArmor(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.getBodyArmorItem().getItem() instanceof RevampedWolfArmorItem) {
            callbackInfo.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Wolf;heal(F)V", shift=At.Shift.AFTER, ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void mobInteractHeal(Player p_30412_, InteractionHand p_30413_, CallbackInfoReturnable<InteractionResult> cir, ItemStack itemstack) {
        this.saturation = Mth.clamp((float)(this.saturation + (float)itemstack.getItem().getFoodProperties(itemstack, (LivingEntity)this).nutrition() * itemstack.getItem().getFoodProperties(itemstack, (LivingEntity)this).saturation() * 2.0f), (float)0.0f, (float)20.0f);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void aiStep(CallbackInfo callbackInfo) {
        if (!this.level().isClientSide && this.isAlive()) {
            if (this.hungerTick > 0) {
                --this.hungerTick;
            }
            ItemStack mainhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isUsingItem() && this.getItemInHand(InteractionHand.MAIN_HAND).getItem().getFoodProperties(mainhand, (LivingEntity)this) != null && this.getItemInHand(InteractionHand.MAIN_HAND).is(ItemTags.MEAT)) {
                if (this.getHealth() < this.getMaxHealth() || !this.isTame()) {
                    ++this.eatTick;
                    if (this.eatTick > 200 && !mainhand.isEmpty()) {
                        this.startUsingItem(InteractionHand.MAIN_HAND);
                    }
                }
            } else {
                this.eatTick = 0;
            }
        }
        if (this.getHealth() < this.getMaxHealth() && this.saturation > 0.0f) {
            this.saturation = Mth.clamp((float)(this.saturation - 0.5f), (float)0.0f, (float)20.0f);
            if (this.saturation >= 0.5f) {
                this.heal(1.0f);
            }
        }
    }

    protected void completeUsingItem() {
        ItemStack copy;
        InteractionHand hand = this.getUsedItemHand();
        if (this.useItem.equals(this.getItemInHand(hand)) && !this.useItem.isEmpty() && this.isUsingItem() && (copy = this.useItem.copy()).getItem().getFoodProperties(this.useItem, (LivingEntity)this) != null) {
            this.heal(copy.getItem().getFoodProperties(this.useItem, (LivingEntity)this).nutrition());
            this.saturation = Mth.clamp((float)(this.saturation + (float)copy.getItem().getFoodProperties(this.useItem, (LivingEntity)this).nutrition() * copy.getItem().getFoodProperties(this.useItem, (LivingEntity)this).saturation() * 2.0f), (float)0.0f, (float)20.0f);
        }
        super.completeUsingItem();
    }

    private void spitOutItem(ItemStack p_28602_) {
        if (!p_28602_.isEmpty() && !this.level().isClientSide) {
            ItemEntity itementity = new ItemEntity(this.level(), this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, p_28602_);
            itementity.setPickUpDelay(40);
            itementity.setThrower((Entity)this);
            this.playSound(SoundEvents.FOX_SPIT, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)itementity);
        }
    }

    private void dropItemStack(ItemStack p_28606_) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), p_28606_);
        this.level().addFreshEntity((Entity)itementity);
    }

    public boolean canHoldItem(ItemStack p_28578_) {
        Item item = p_28578_.getItem();
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        return itemstack.isEmpty() && p_28578_.is(ItemTags.MEAT);
    }

    protected void pickUpItem(ItemEntity p_28514_) {
        ItemStack itemstack;
        if (!this.isTame() && this.canHoldItem(itemstack = p_28514_.getItem())) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.spitOutItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
            this.onItemPickup(p_28514_);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 2.0f;
            this.take((Entity)p_28514_, itemstack.getCount());
            p_28514_.discard();
            this.eatTick = 0;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void addAdditionalSaveData(CompoundTag p_213281_1_, CallbackInfo callbackInfo) {
        p_213281_1_.putInt("HuntingCooldown", this.huntCooldown);
        p_213281_1_.putInt("EatTick", this.eatTick);
        p_213281_1_.putInt("HungerTick", this.hungerTick);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    public void readAdditionalSaveData(CompoundTag p_70037_1_, CallbackInfo callbackInfo) {
        this.huntCooldown = p_70037_1_.getInt("HuntingCooldown");
        this.eatTick = p_70037_1_.getInt("EatTick");
        this.hungerTick = p_70037_1_.getInt("HungerTick");
        this.setCanPickUpLoot(true);
    }

    public boolean killedEntity(ServerLevel p_216988_, LivingEntity p_216989_) {
        this.setHuntCooldown(1200);
        return super.killedEntity(p_216988_, p_216989_);
    }

    @Override
    public void setHuntCooldown(int cooldown) {
        this.huntCooldown = cooldown;
    }

    @Override
    public int getHuntCooldown() {
        return this.huntCooldown;
    }

    @Override
    public boolean isHunted() {
        return this.huntCooldown > 0;
    }

    @Override
    public int getHunger() {
        return this.hungerTick;
    }

    @Override
    public void setHunger(int hunger) {
        this.hungerTick = hunger;
    }
}

