/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.client.dialog;

import bagu_chan.bagus_lib.client.dialog.DialogType;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemDialogType
extends DialogType {
    protected ItemStack itemStack = ItemStack.EMPTY;

    @Override
    public void render(GuiGraphics guiGraphics, PoseStack poseStack, float f, float tickCount) {
        if (this.itemStack != null) {
            poseStack.pushPose();
            poseStack.translate(0.0f, (float)this.renderDialogY, 0.0f);
            poseStack.scale(this.scaleX, this.scaleY, 1.0f);
            guiGraphics.renderItem(this.itemStack, this.posX, this.posY);
            poseStack.popPose();
        }
    }

    @Override
    public ItemDialogType getClone() {
        ItemDialogType dialog = new ItemDialogType();
        dialog.readTag(this.writeTag());
        return dialog;
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tag = super.writeTag();
        if (this.itemStack != null) {
            tag.putString("Item", BuiltInRegistries.ITEM.getKey((Object)this.itemStack.getItem()).toString());
        }
        return tag;
    }

    @Override
    public void readTag(CompoundTag tag) {
        super.readTag(tag);
        if (tag.contains("Item")) {
            this.itemStack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)tag.getString("Item")))).getDefaultInstance();
        }
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

