/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client;

import baguchi.bagus_lib.BagusConfigs;
import baguchi.bagus_lib.client.event.BagusModelEvent;
import baguchi.bagus_lib.client.game.WaterMelonScreen;
import baguchi.bagus_lib.util.DialogHandler;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="bagus_lib")
public class ClientEventHandler {
    private static boolean initDate = false;
    private static boolean aprilFools = false;

    @SubscribeEvent
    public static void screenRender(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            if (ClientEventHandler.isAprilFools()) {
                int l = titleScreen.height / 4 + 48;
                event.addListener((GuiEventListener)Button.builder((Component)Component.translatable((String)"bagus_lib.watermelon"), p_280785_ -> Minecraft.getInstance().setScreen((Screen)new WaterMelonScreen((Component)Component.empty()))).bounds(titleScreen.width / 2 - 100, l - 24, 100, 20).build());
            }
        }
    }

    public static boolean isAprilFools() {
        if (!initDate) {
            initDate = true;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            aprilFools = calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
        }
        return aprilFools && (Boolean)BagusConfigs.COMMON.aprilFool.get() != false;
    }

    @SubscribeEvent
    public static void clientLoggOut(PlayerEvent.PlayerLoggedOutEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void clientRespawn(PlayerEvent.PlayerRespawnEvent event) {
        DialogHandler.INSTANCE.removeAllDialogType();
    }

    @SubscribeEvent
    public static void animationArmEvent(RenderHandEvent event) {
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)Minecraft.getInstance().player);
        EntityModel entityModel = playerrenderer.getModel();
        PlayerRenderState renderState = playerrenderer.createRenderState();
        playerrenderer.createRenderState((Entity)Minecraft.getInstance().player, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaTicks());
        BagusModelEvent.FirstPersonArmAnimate event2 = new BagusModelEvent.FirstPersonArmAnimate((LivingEntityRenderState)renderState, entityModel, event.getHand(), event.getPoseStack());
        NeoForge.EVENT_BUS.post((Event)event2);
    }
}

