/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.layer;

import baguchi.bagus_lib.api.IBaguData;
import baguchi.bagus_lib.client.ModModelLayers;
import baguchi.bagus_lib.client.layer.IArmor;
import baguchi.bagus_lib.client.render.MiniBaguModel;
import baguchi.bagus_lib.client.render.MiniBaguRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class BagusLayer<T extends LivingEntityRenderState, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final MiniBaguModel bagumodel;
    private RenderLayerParent<T, M> renderer;

    public BagusLayer(RenderLayerParent<T, M> render, EntityRendererProvider.Context context) {
        super(render);
        this.bagumodel = new MiniBaguModel(context.bakeLayer(ModModelLayers.MINI_BAGU));
        this.renderer = render;
    }

    public BagusLayer(RenderLayerParent<T, M> render, EntityModelSet modelSet, ModelManager modelManager) {
        super(render);
        this.bagumodel = new MiniBaguModel(modelSet.bakeLayer(ModModelLayers.MINI_BAGU));
        this.renderer = render;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float p_117353_, float p_117354_) {
        IBaguData data;
        CompoundTag tag;
        if (entity instanceof IBaguData && (tag = (data = (IBaguData)entity).getBagusData()).contains("BaguCosmetic") && tag.getBoolean("BaguCosmetic")) {
            poseStack.pushPose();
            this.renderHelmet(entity, poseStack, bufferIn, packedLightIn, true, this.bagumodel, 1.0f, 1.0f, 1.0f, MiniBaguRenderer.TEXTURE);
            poseStack.popPose();
        }
    }

    private void renderHelmet(T entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, MiniBaguModel modelIn, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)armorResource));
        ((IArmor)this.renderer.getModel()).headPartArmors().forEach(part -> {
            poseStack.pushPose();
            part.translateAndRotate(poseStack);
            poseStack.translate(0.0f, -1.9f, 0.0f);
            modelIn.renderToBuffer(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        });
    }
}

