/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.layer;

import baguchi.bagus_lib.api.IBagusExtraRenderState;
import baguchi.bagus_lib.client.layer.IArmor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.EquipmentModelSet;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentModel;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class CustomArmorLayer<S extends LivingEntityRenderState, M extends EntityModel<S>, A extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final HumanoidModel defaultBipedModel;
    private final HumanoidModel innerModel;
    private RenderLayerParent<S, M> renderer;
    private final TextureAtlas armorTrimAtlas;
    private final EquipmentModelSet equipmentModelSet;

    public CustomArmorLayer(RenderLayerParent<S, M> render, EntityRendererProvider.Context context) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.innerModel = new HumanoidModel(context.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.renderer = render;
        this.armorTrimAtlas = context.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        this.equipmentModelSet = context.getEquipmentModels();
    }

    public CustomArmorLayer(RenderLayerParent<S, M> render, EntityModelSet modelSet, ModelManager modelManager, EquipmentModelSet equipmentModelSet) {
        super(render);
        this.defaultBipedModel = new HumanoidModel(modelSet.bakeLayer(ModelLayers.ARMOR_STAND_OUTER_ARMOR));
        this.innerModel = new HumanoidModel(modelSet.bakeLayer(ModelLayers.ARMOR_STAND_INNER_ARMOR));
        this.renderer = render;
        this.armorTrimAtlas = modelManager.getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        this.equipmentModelSet = equipmentModelSet;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int light, S entity, float p_117353_, float p_117354_) {
        if (entity instanceof IBagusExtraRenderState) {
            ArmorItem armoritem;
            ArmorItem armoritem2;
            ArmorItem armoritem3;
            IBagusExtraRenderState bagusExtraRenderState = (IBagusExtraRenderState)entity;
            poseStack.pushPose();
            ItemStack headItem = ((LivingEntityRenderState)entity).headItem;
            if (headItem.getItem() instanceof ArmorItem) {
                ArmorItem armoritem4 = (ArmorItem)headItem.getItem();
                EquipmentModel.LayerType equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.HEAD) ? EquipmentModel.LayerType.HUMANOID_LEGGINGS : EquipmentModel.LayerType.HUMANOID;
                HumanoidModel<?> a = this.defaultBipedModel;
                a = this.getArmorModelHook(headItem, equipmentmodel$layerType, (HumanoidModel)a);
                boolean notAVanillaModel = a != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                boolean flag1 = headItem.hasFoil();
                int clampedLight = light;
                if (headItem.is(ItemTags.DYEABLE)) {
                    extensions = IClientItemExtensions.of((ItemStack)headItem);
                    i = extensions.getDefaultDyeColor(headItem);
                    this.renderHelmet(headItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                    this.renderHelmet(headItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                } else {
                    extensions = IClientItemExtensions.of((ItemStack)headItem);
                    i = extensions.getDefaultDyeColor(headItem);
                    this.renderHelmet(headItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                }
            }
            poseStack.popPose();
            poseStack.pushPose();
            ItemStack chestItem = bagusExtraRenderState.getBagusLib$chestItem();
            if (chestItem.getItem() instanceof ArmorItem && (armoritem3 = (ArmorItem)chestItem.getItem()).getEquipmentSlot(chestItem) == EquipmentSlot.CHEST) {
                EquipmentModel.LayerType equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.CHEST) ? EquipmentModel.LayerType.HUMANOID_LEGGINGS : EquipmentModel.LayerType.HUMANOID;
                boolean flag = CustomArmorLayer.usesInnerModel(armoritem3.getEquipmentSlot(chestItem));
                HumanoidModel<?> a = this.defaultBipedModel;
                a = this.getArmorModelHook(chestItem, equipmentmodel$layerType, (HumanoidModel)a);
                boolean notAVanillaModel = a != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.CHEST);
                boolean flag1 = chestItem.hasFoil();
                int clampedLight = light;
                if (chestItem.is(ItemTags.DYEABLE)) {
                    extensions = IClientItemExtensions.of((ItemStack)chestItem);
                    i = extensions.getDefaultDyeColor(chestItem);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderChestplate(chestItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                    this.renderChestplate(chestItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                } else {
                    extensions = IClientItemExtensions.of((ItemStack)chestItem);
                    i = extensions.getDefaultDyeColor(chestItem);
                    this.renderChestplate(chestItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                }
            }
            poseStack.popPose();
            poseStack.pushPose();
            ItemStack legItem = bagusExtraRenderState.getBagusLib$legItem();
            if (legItem.getItem() instanceof ArmorItem && (armoritem2 = (ArmorItem)legItem.getItem()).getEquipmentSlot(legItem) == EquipmentSlot.LEGS) {
                EquipmentModel.LayerType equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.LEGS) ? EquipmentModel.LayerType.HUMANOID_LEGGINGS : EquipmentModel.LayerType.HUMANOID;
                boolean flag = CustomArmorLayer.usesInnerModel(armoritem2.getEquipmentSlot(legItem));
                HumanoidModel<?> a = this.innerModel;
                a = this.getArmorModelHook(legItem, equipmentmodel$layerType, (HumanoidModel)a);
                boolean notAVanillaModel = a != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.LEGS);
                boolean flag1 = legItem.hasFoil();
                int clampedLight = light;
                if (legItem.is(ItemTags.DYEABLE)) {
                    IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)legItem);
                    int i = extensions.getDefaultDyeColor(legItem);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderLeg(legItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                    this.renderLeg(legItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                } else {
                    IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)legItem);
                    int i = extensions.getDefaultDyeColor(legItem);
                    this.renderLeg(legItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                }
            }
            poseStack.popPose();
            poseStack.pushPose();
            ItemStack feetItem = bagusExtraRenderState.getBagusLib$feetItem();
            if (feetItem.getItem() instanceof ArmorItem && (armoritem = (ArmorItem)feetItem.getItem()).getEquipmentSlot(feetItem) == EquipmentSlot.FEET) {
                EquipmentModel.LayerType equipmentmodel$layerType = CustomArmorLayer.usesInnerModel(EquipmentSlot.FEET) ? EquipmentModel.LayerType.HUMANOID_LEGGINGS : EquipmentModel.LayerType.HUMANOID;
                boolean flag = CustomArmorLayer.usesInnerModel(armoritem.getEquipmentSlot(feetItem));
                HumanoidModel<?> a = this.defaultBipedModel;
                a = this.getArmorModelHook(feetItem, equipmentmodel$layerType, (HumanoidModel)a);
                boolean notAVanillaModel = a != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.FEET);
                boolean flag1 = feetItem.hasFoil();
                int clampedLight = light;
                if (feetItem.is(ItemTags.DYEABLE)) {
                    IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)feetItem);
                    int i = extensions.getDefaultDyeColor(feetItem);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderBoot(feetItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                    this.renderBoot(feetItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                } else {
                    IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)feetItem);
                    int i = extensions.getDefaultDyeColor(feetItem);
                    this.renderBoot(feetItem, entity, poseStack, bufferIn, clampedLight, flag1, a, i);
                }
            }
            poseStack.popPose();
        }
    }

    private static boolean usesInnerModel(EquipmentSlot p_117129_) {
        return p_117129_ == EquipmentSlot.LEGS;
    }

    private void renderLeg(ItemStack legItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, int color) {
        Equippable equippable = (Equippable)legItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.model().isEmpty()) {
            int idx = 0;
            for (EquipmentModel.Layer layer : (List)this.equipmentModelSet.get((ResourceLocation)equippable.model().get()).layers().get(EquipmentModel.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)legItem);
                int j = extensions.getArmorLayerTintColor(legItem, layer, idx, color);
                if (j != 0) {
                    VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)layer.getTextureLocation(EquipmentModel.LayerType.HUMANOID)), (boolean)false, (boolean)glintIn);
                    modelIn.body.xRot = 0.0f;
                    modelIn.body.yRot = 0.0f;
                    modelIn.body.zRot = 0.0f;
                    modelIn.body.x = 0.0f;
                    modelIn.body.y = 0.0f;
                    modelIn.body.z = 0.0f;
                    modelIn.rightLeg.x = 0.0f;
                    modelIn.rightLeg.xRot = 0.0f;
                    modelIn.rightLeg.yRot = 0.0f;
                    modelIn.rightLeg.zRot = 0.0f;
                    modelIn.leftLeg.x = 0.0f;
                    modelIn.leftLeg.xRot = 0.0f;
                    modelIn.leftLeg.yRot = 0.0f;
                    modelIn.leftLeg.zRot = 0.0f;
                    modelIn.leftLeg.y = 0.0f;
                    modelIn.rightLeg.y = 0.0f;
                    modelIn.leftLeg.z = 0.0f;
                    modelIn.rightLeg.z = 0.0f;
                    ((IArmor)this.getParentModel()).rightLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        modelIn.rightLeg.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).leftLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        modelIn.leftLeg.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).bodyPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToChest((ModelPart)part, poseStack);
                        modelIn.body.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    private void renderBoot(ItemStack feetItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, int color) {
        Equippable equippable = (Equippable)feetItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.model().isEmpty()) {
            int idx = 0;
            for (EquipmentModel.Layer layer : (List)this.equipmentModelSet.get((ResourceLocation)equippable.model().get()).layers().get(EquipmentModel.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)feetItem);
                int j = extensions.getArmorLayerTintColor(feetItem, layer, idx, color);
                if (j != 0) {
                    VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)layer.getTextureLocation(EquipmentModel.LayerType.HUMANOID)), (boolean)false, (boolean)glintIn);
                    modelIn.rightLeg.x = 0.0f;
                    modelIn.rightLeg.xRot = 0.0f;
                    modelIn.rightLeg.yRot = 0.0f;
                    modelIn.rightLeg.zRot = 0.0f;
                    modelIn.leftLeg.x = 0.0f;
                    modelIn.leftLeg.xRot = 0.0f;
                    modelIn.leftLeg.yRot = 0.0f;
                    modelIn.leftLeg.zRot = 0.0f;
                    modelIn.leftLeg.y = 0.0f;
                    modelIn.rightLeg.y = 0.0f;
                    modelIn.leftLeg.z = 0.0f;
                    modelIn.rightLeg.z = 0.0f;
                    ((IArmor)this.getParentModel()).rightLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        modelIn.rightLeg.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).leftLegPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToLeg((ModelPart)part, poseStack);
                        modelIn.leftLeg.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    private void renderChestplate(ItemStack chestItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, int color) {
        Equippable equippable = (Equippable)chestItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.model().isEmpty()) {
            int idx = 0;
            for (EquipmentModel.Layer layer : (List)this.equipmentModelSet.get((ResourceLocation)equippable.model().get()).layers().get(EquipmentModel.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)chestItem);
                int j = extensions.getArmorLayerTintColor(chestItem, layer, idx, color);
                if (j != 0) {
                    VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)layer.getTextureLocation(EquipmentModel.LayerType.HUMANOID)), (boolean)false, (boolean)glintIn);
                    modelIn.body.xRot = 0.0f;
                    modelIn.body.yRot = 0.0f;
                    modelIn.body.zRot = 0.0f;
                    modelIn.body.x = 0.0f;
                    modelIn.body.y = 0.0f;
                    modelIn.body.z = 0.0f;
                    modelIn.rightArm.x = 0.0f;
                    modelIn.rightArm.y = 0.0f;
                    modelIn.rightArm.z = 0.0f;
                    modelIn.rightArm.xRot = 0.0f;
                    modelIn.rightArm.yRot = 0.0f;
                    modelIn.rightArm.zRot = 0.0f;
                    modelIn.leftArm.x = 0.0f;
                    modelIn.leftArm.y = 0.0f;
                    modelIn.leftArm.z = 0.0f;
                    modelIn.leftArm.xRot = 0.0f;
                    modelIn.leftArm.yRot = 0.0f;
                    modelIn.leftArm.zRot = 0.0f;
                    modelIn.leftArm.y = 0.0f;
                    modelIn.rightArm.y = 0.0f;
                    modelIn.leftArm.z = 0.0f;
                    modelIn.rightArm.z = 0.0f;
                    ((IArmor)this.getParentModel()).rightHandArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToChestPat((ModelPart)part, poseStack);
                        modelIn.rightArm.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).leftHandArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToChestPat((ModelPart)part, poseStack);
                        modelIn.leftArm.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                    ((IArmor)this.getParentModel()).bodyPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToChest((ModelPart)part, poseStack);
                        modelIn.body.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    private void renderHelmet(ItemStack headItem, S entity, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, int color) {
        Equippable equippable = (Equippable)headItem.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.model().isEmpty()) {
            int idx = 0;
            for (EquipmentModel.Layer layer : (List)this.equipmentModelSet.get((ResourceLocation)equippable.model().get()).layers().get(EquipmentModel.LayerType.HUMANOID)) {
                IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)headItem);
                int j = extensions.getArmorLayerTintColor(headItem, layer, idx, color);
                if (j != 0) {
                    VertexConsumer ivertexbuilder = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)layer.getTextureLocation(EquipmentModel.LayerType.HUMANOID)), (boolean)false, (boolean)glintIn);
                    modelIn.head.xRot = 0.0f;
                    modelIn.head.yRot = 0.0f;
                    modelIn.head.zRot = 0.0f;
                    modelIn.hat.xRot = 0.0f;
                    modelIn.hat.yRot = 0.0f;
                    modelIn.hat.zRot = 0.0f;
                    modelIn.head.x = 0.0f;
                    modelIn.head.y = 0.0f;
                    modelIn.head.z = 0.0f;
                    modelIn.hat.x = 0.0f;
                    modelIn.hat.y = 0.0f;
                    modelIn.hat.z = 0.0f;
                    ((IArmor)this.getParentModel()).headPartArmors().forEach(part -> {
                        poseStack.pushPose();
                        ((IArmor)this.getParentModel()).translateToHead((ModelPart)part, poseStack);
                        modelIn.head.render(poseStack, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, j);
                        poseStack.popPose();
                    });
                }
                ++idx;
            }
        }
    }

    protected void setModelSlotVisible(HumanoidModel p_188359_1_, EquipmentSlot slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.head.visible = true;
                p_188359_1_.hat.visible = true;
                break;
            }
            case CHEST: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightArm.visible = true;
                p_188359_1_.leftArm.visible = true;
                break;
            }
            case LEGS: {
                p_188359_1_.body.visible = true;
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
                break;
            }
            case FEET: {
                p_188359_1_.rightLeg.visible = true;
                p_188359_1_.leftLeg.visible = true;
            }
        }
    }

    protected void setModelVisible(HumanoidModel model) {
        model.setAllVisible(false);
    }

    protected HumanoidModel<?> getArmorModelHook(ItemStack itemStack, EquipmentModel.LayerType slot, HumanoidModel model) {
        Model basicModel = ClientHooks.getArmorModel((ItemStack)itemStack, (EquipmentModel.LayerType)slot, (Model)model);
        return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
    }
}

