/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.loot;

import baguchi.bagus_lib.register.ModLootModifiers;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class OneItemLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<OneItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> OneItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(m -> m.lootTable)).apply((Applicative)inst, OneItemLootModifier::new)));
    public final ResourceLocation lootTable;

    public OneItemLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        List<ItemStack> itemStacks;
        ObjectArrayList stacks = new ObjectArrayList();
        Optional extraTable = context.getResolver().get(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable));
        if (extraTable.isPresent()) {
            ((LootTable)((Holder.Reference)extraTable.get()).value()).getRandomItemsRaw(context, arg_0 -> ((ObjectArrayList)stacks).add(arg_0));
        }
        if (!(itemStacks = stacks.stream().filter(itemStack -> !itemStack.isEmpty()).toList()).isEmpty()) {
            return stacks;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)ModLootModifiers.ONE_IN_LOOT.get();
    }
}

