/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.fluids.client.FluidParticleColors;
import net.mehvahdjukaar.selene.util.PotionNBTHelper;
import net.mehvahdjukaar.selene.util.Utils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LingeringPotionItem;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.SplashPotionItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SoftFluidHolder {
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    private int count = 0;
    private final int capacity;
    @Nullable
    private CompoundNBT nbt = null;
    private SoftFluid fluid = SoftFluidRegistry.EMPTY;
    private int specialColor = 0;
    private boolean needColorRefresh = true;

    public SoftFluidHolder(int capacity) {
        this.capacity = capacity;
    }

    public boolean interactWithPlayer(PlayerEntity player, Hand hand, @Nullable World world, @Nullable BlockPos pos) {
        ItemStack handStack = player.func_184586_b(hand);
        ItemStack returnStack = this.interactWithItem(handStack, world, pos, false);
        if (returnStack != null) {
            Utils.swapItem(player, hand, returnStack);
            if (!handStack.func_190926_b()) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)handStack.func_77973_b()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ItemStack interactWithItem(ItemStack stack, @Nullable World world, @Nullable BlockPos pos, boolean simulate) {
        ItemStack returnStack = this.tryFillingItem(stack.func_77973_b(), world, pos, simulate);
        if (returnStack != null) {
            return returnStack;
        }
        returnStack = this.tryDrainItem(stack, world, pos, simulate);
        return returnStack;
    }

    private void applyNBTtoItemStack(ItemStack stack) {
        String[] nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.isEmpty() && nbtKey != null) {
            CompoundNBT newCom = new CompoundNBT();
            for (String s : nbtKey) {
                if (!this.nbt.func_74764_b(s) || s.equals("Bottle")) continue;
                newCom.func_218657_a(s, this.nbt.func_74781_a(s));
            }
            if (!newCom.isEmpty()) {
                stack.func_77982_d(newCom);
            }
        }
    }

    private void addPotionTag(Item i, CompoundNBT com) {
        String type = "REGULAR";
        if (i instanceof SplashPotionItem) {
            type = "SPLASH";
        } else if (i instanceof LingeringPotionItem) {
            type = "LINGERING";
        }
        com.func_74778_a("Bottle", type);
    }

    @Nullable
    public ItemStack tryDrainItem(ItemStack filledContainerStack, @Nullable World world, @Nullable BlockPos pos, boolean simulate) {
        int amount;
        Item empty;
        SoftFluid.FilledContainerCategory category;
        boolean hasCustomPot;
        Item filledContainer = filledContainerStack.func_77973_b();
        SoftFluid s = SoftFluidRegistry.fromItem(filledContainer);
        if (s.isEmpty()) {
            return null;
        }
        CompoundNBT com = filledContainerStack.func_77978_p();
        CompoundNBT newCom = new CompoundNBT();
        Potion potion = PotionUtils.func_185191_c((ItemStack)filledContainerStack);
        boolean bl = hasCustomPot = com != null && com.func_74764_b("CustomPotionEffects");
        if (potion == Potions.field_185230_b && !hasCustomPot) {
            s = SoftFluidRegistry.WATER;
        } else if (potion != Potions.field_185229_a || hasCustomPot) {
            this.addPotionTag(filledContainer, newCom);
        }
        String[] nbtKey = s.getNbtKeyFromItem();
        if (com != null && nbtKey != null) {
            for (String k : nbtKey) {
                if (!com.func_74764_b(k)) continue;
                newCom.func_218657_a(k, com.func_74781_a(k));
            }
        }
        if (this.isEmpty()) {
            this.setFluid(s, newCom.isEmpty() ? null : newCom);
        }
        if (potion == Potions.field_185230_b) {
            s = SoftFluidRegistry.POTION;
        }
        if ((category = s.tryGettingFilledItems(empty = s.tryGettingEmptyItem(filledContainer))) != null && empty != null && this.canAddSoftFluid(this.fluid, amount = category.getAmount(), newCom)) {
            if (simulate) {
                return ItemStack.field_190927_a;
            }
            this.grow(amount);
            SoundEvent sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return new ItemStack((IItemProvider)empty);
        }
        return null;
    }

    @Nullable
    public ItemStack tryFillingItem(Item emptyContainer, @Nullable World world, @Nullable BlockPos pos, boolean simulate) {
        int amount;
        SoftFluid.FilledContainerCategory category = this.fluid.tryGettingFilledItems(emptyContainer);
        if (category != null && this.canRemove(amount = category.getAmount())) {
            if (simulate) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = new ItemStack((IItemProvider)category.getFirstFilled());
            if (this.fluid == SoftFluidRegistry.POTION && this.nbt != null && this.nbt.func_74764_b("Bottle") && !emptyContainer.getRegistryName().func_110624_b().equals("inspirations")) {
                String bottle = this.nbt.func_74779_i("Bottle");
                if (bottle.equals("SPLASH")) {
                    stack = new ItemStack((IItemProvider)Items.field_185155_bH);
                } else if (bottle.equals("LINGERING")) {
                    stack = new ItemStack((IItemProvider)Items.field_185156_bI);
                }
            }
            if (emptyContainer == Items.field_151069_bo && this.fluid == SoftFluidRegistry.WATER) {
                stack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
            }
            this.applyNBTtoItemStack(stack);
            this.shrink(amount);
            SoundEvent sound = category.getEmptySound();
            if (sound != null && world != null && pos != null) {
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return stack;
        }
        return null;
    }

    @Nullable
    public ItemStack tryFillingBottle(World world, BlockPos pos) {
        return this.tryFillingItem(Items.field_151069_bo, world, pos, false);
    }

    @Nullable
    public ItemStack tryFillingBucket(World world, BlockPos pos) {
        return this.tryFillingItem(Items.field_151133_ar, world, pos, false);
    }

    @Nullable
    public ItemStack tryFillingBowl(World world, BlockPos pos) {
        return this.tryFillingItem(Items.field_151054_z, world, pos, false);
    }

    public boolean isSameFluidAs(FluidStack fluidStack, CompoundNBT com) {
        return this.fluid.isEquivalent(fluidStack.getFluid()) && this.areNbtEquals(com, this.nbt);
    }

    public boolean isSameFluidAs(FluidStack fluidStack) {
        return this.isSameFluidAs(fluidStack, fluidStack.getTag());
    }

    private boolean areNbtEquals(CompoundNBT nbt, CompoundNBT nbt1) {
        return (nbt == null || nbt.isEmpty()) && (nbt1 == null || nbt1.isEmpty()) || nbt1.equals((Object)nbt);
    }

    public boolean isSameFluidAs(SoftFluid other) {
        return this.isSameFluidAs(other, null);
    }

    public boolean isSameFluidAs(SoftFluid other, @Nullable CompoundNBT com) {
        return this.fluid.equals(other) && this.areNbtEquals(this.nbt, com);
    }

    public boolean tryAddingFluid(FluidStack fluidStack) {
        int count = fluidStack.getAmount();
        SoftFluid s = SoftFluidRegistry.fromForgeFluid(this.fluid.getForgeFluid());
        return this.tryAddingFluid(s, count, fluidStack.getTag());
    }

    public boolean tryAddingFluid(SoftFluid s, int count, @Nullable CompoundNBT com) {
        if (this.canAdd(count)) {
            if (this.isEmpty()) {
                this.setFluid(s, com);
                this.setCount(count);
                return true;
            }
            if (this.isSameFluidAs(s, com)) {
                this.grow(count);
                return true;
            }
        }
        return false;
    }

    public boolean tryAddingFluid(SoftFluid s, int count) {
        return this.tryAddingFluid(s, count, null);
    }

    public boolean tryAddingFluid(SoftFluid s) {
        return this.tryAddingFluid(s, 1);
    }

    public boolean tryTransferFluid(SoftFluidHolder destination) {
        return this.tryTransferFluid(destination, 1);
    }

    public boolean tryTransferFluid(SoftFluidHolder destination, int amount) {
        if (destination.canAdd(amount) && this.canRemove(amount)) {
            if (destination.isEmpty()) {
                destination.setFluid(this.getFluid(), this.getNbt());
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
            if (this.isSameFluidAs(destination.getFluid(), destination.nbt)) {
                this.shrink(amount);
                destination.grow(amount);
                return true;
            }
        }
        return false;
    }

    public boolean tryTransferToFluidTank(IFluidHandler fluidDestination, int bottles) {
        int fillableAmount;
        if (!this.canRemove(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack stack = this.toEquivalentForgeFluid(milliBuckets);
        if (!stack.isEmpty() && (fillableAmount = fluidDestination.fill(stack, IFluidHandler.FluidAction.SIMULATE)) == milliBuckets) {
            fluidDestination.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            this.shrink(bottles);
            return true;
        }
        return false;
    }

    public boolean tryTransferToFluidTank(IFluidHandler fluidDestination) {
        return this.tryTransferToFluidTank(fluidDestination, 1);
    }

    public boolean drainFluidTank(IFluidHandler fluidSource, int bottles) {
        if (!this.canAdd(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack drainable = fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && drainable.getAmount() == milliBuckets) {
            boolean transfer = false;
            CompoundNBT fsTag = drainable.getTag();
            if (this.fluid.isEmpty()) {
                this.setFluid(SoftFluidRegistry.fromForgeFluid(drainable.getFluid()), fsTag);
                transfer = true;
            } else if (this.isSameFluidAs(drainable, fsTag)) {
                transfer = true;
            }
            if (transfer) {
                fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.EXECUTE);
                this.grow(bottles);
                return true;
            }
        }
        return false;
    }

    public boolean drainFluidTank(IFluidHandler fluidSource) {
        return this.drainFluidTank(fluidSource, 1);
    }

    public FluidStack toEquivalentForgeFluid(int mb) {
        FluidStack stack = new FluidStack(this.fluid.getForgeFluid(), mb);
        this.applyNBTtoFluidStack(stack);
        return stack;
    }

    private void applyNBTtoFluidStack(FluidStack fluidStack) {
        String[] nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.isEmpty() && !fluidStack.isEmpty() && nbtKey != null) {
            CompoundNBT newCom = new CompoundNBT();
            for (String k : nbtKey) {
                if (!this.nbt.func_74764_b(k)) continue;
                newCom.func_218657_a(k, this.nbt.func_74781_a(k));
            }
            if (!newCom.isEmpty()) {
                fluidStack.setTag(newCom);
            }
        }
    }

    public boolean canRemove(int n) {
        return this.count >= n && !this.isEmpty();
    }

    public boolean canAdd(int n) {
        return this.count + n <= this.capacity;
    }

    public boolean canAddSoftFluid(SoftFluid s, int count) {
        return this.canAddSoftFluid(s, count, null);
    }

    public boolean canAddSoftFluid(SoftFluid s, int count, @Nullable CompoundNBT nbt) {
        return this.canAdd(count) && this.isSameFluidAs(s, nbt);
    }

    public boolean isFull() {
        return this.count == this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty() || this.count <= 0;
    }

    public void lossyAdd(int inc) {
        this.count = Math.min(this.capacity, this.count + inc);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void fillCount() {
        this.setCount(this.capacity);
    }

    public void grow(int inc) {
        this.setCount(this.count + inc);
    }

    public void shrink(int inc) {
        this.grow(-inc);
        if (this.count == 0) {
            this.fluid = SoftFluidRegistry.EMPTY;
        }
    }

    public float getHeight(float maxHeight) {
        return maxHeight * (float)this.count / (float)this.capacity;
    }

    public int getComparatorOutput() {
        float f = (float)this.count / (float)this.capacity;
        return MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
    }

    public int getCount() {
        return this.count;
    }

    @Nonnull
    public SoftFluid getFluid() {
        return this.fluid;
    }

    @Nullable
    public CompoundNBT getNbt() {
        return this.nbt;
    }

    public void setNbt(@Nullable CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public void clear() {
        this.fluid = SoftFluidRegistry.EMPTY;
        this.setCount(0);
        this.nbt = null;
        this.specialColor = 0;
    }

    public void copy(SoftFluidHolder other) {
        this.setFluid(other.getFluid(), other.getNbt());
        this.setCount(Math.min(this.capacity, other.getCount()));
    }

    public void copy(IFluidHandler other) {
        FluidStack drainable = other.drain(250, IFluidHandler.FluidAction.SIMULATE);
        CompoundNBT nbt = drainable.isEmpty() ? null : drainable.getTag();
        this.setFluid(SoftFluidRegistry.fromForgeFluid(drainable.getFluid()), nbt);
        this.setCount(Math.min(this.capacity, other.getTankCapacity(0)));
    }

    public void fill(FluidStack fluidStack) {
        this.setFluid(fluidStack);
        this.fillCount();
    }

    public void fill(SoftFluid fluid) {
        this.fill(fluid, null);
    }

    public void fill(SoftFluid fluid, @Nullable CompoundNBT nbt) {
        this.setFluid(fluid, nbt);
        this.fillCount();
    }

    public void setFluid(FluidStack fluidStack) {
        SoftFluid s = SoftFluidRegistry.fromForgeFluid(fluidStack.getFluid());
        this.setFluid(s, fluidStack.getTag());
    }

    public void setFluid(SoftFluid fluid) {
        this.setFluid(fluid, null);
    }

    public void setFluid(SoftFluid fluid, @Nullable CompoundNBT nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.specialColor = 0;
        if (this.fluid.isEmpty()) {
            this.setCount(0);
        }
        this.needColorRefresh = true;
    }

    public int getTintColor(@Nullable IWorldReader world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        if (this.needColorRefresh) {
            this.refreshSpecialColor(world, pos);
            this.needColorRefresh = false;
        }
        if (this.specialColor != 0) {
            return this.specialColor;
        }
        return this.fluid.getTintColor();
    }

    public int getFlowingTint(@Nullable IWorldReader world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getTintColor(world, pos);
    }

    public int getParticleColor(@Nullable IWorldReader world, @Nullable BlockPos pos) {
        if (this.isEmpty()) {
            return -1;
        }
        int tintColor = this.getTintColor(world, pos);
        if (tintColor == -1) {
            return FluidParticleColors.get(this.fluid.getID());
        }
        return tintColor;
    }

    private void refreshSpecialColor(@Nullable IWorldReader world, @Nullable BlockPos pos) {
        if (this.fluid == SoftFluidRegistry.POTION) {
            this.specialColor = PotionNBTHelper.getColorFromNBT(this.nbt);
        } else {
            Fluid f = this.getFluid().getForgeFluid();
            if (f != Fluids.field_204541_a) {
                FluidAttributes att = f.getAttributes();
                int w = -1;
                if (world != null && pos != null) {
                    w = att.getColor((IBlockDisplayReader)world, pos);
                }
                if (w == -1) {
                    w = att.getColor(this.toEquivalentForgeFluid(1));
                }
                if (w != -1) {
                    this.specialColor = w;
                }
            }
        }
    }

    public boolean isFood() {
        return this.fluid.isFood();
    }

    public ItemStack getFood() {
        ItemStack stack = new ItemStack((IItemProvider)this.fluid.getFoodItem());
        this.applyNBTtoItemStack(stack);
        return stack;
    }

    public void load(CompoundNBT compound) {
        if (compound.func_74764_b("FluidHolder")) {
            CompoundNBT cmp = compound.func_74775_l("FluidHolder");
            this.count = cmp.func_74762_e("Count");
            this.nbt = cmp.func_74775_l("NBT");
            String id = cmp.func_74779_i("Fluid");
            SoftFluid sf = SoftFluidRegistry.get(id);
            if (sf.isEmpty() && (sf = SoftFluidRegistry.get(id.replace("supplementaries", "minecraft"))).isEmpty()) {
                sf = SoftFluidRegistry.get(id.replace("minecraft", "supplementaries"));
            }
            this.setFluid(sf, this.nbt);
        }
    }

    public CompoundNBT save(CompoundNBT compound) {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74768_a("Count", this.count);
        cmp.func_74778_a("Fluid", this.fluid.getID());
        cmp.func_74768_a("CachedColor", this.getTintColor(null, null));
        if (this.nbt != null && !this.nbt.isEmpty()) {
            cmp.func_218657_a("NBT", (INBT)this.nbt);
        }
        compound.func_218657_a("FluidHolder", (INBT)cmp);
        return compound;
    }

    public boolean tryDrinkUpFluid(PlayerEntity player, World world, Hand hand) {
        if (this.isEmpty()) {
            return false;
        }
        ItemStack stack = this.getFood();
        Item item = stack.func_77973_b();
        if (this.fluid == SoftFluidRegistry.XP) {
            player.func_195068_e(Utils.getXPinaBottle(1, world.field_73012_v));
            if (world.field_72995_K) {
                return true;
            }
            this.shrink(1);
            player.func_213823_a(SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        if (this.isFood()) {
            Food food = item.func_219967_s();
            int div = this.fluid.getFoodDivider();
            if (div == 1) {
                stack.func_77973_b().func_77654_b(stack.func_77946_l(), world, (LivingEntity)player);
                if (world.field_72995_K) {
                    return true;
                }
                this.shrink(1);
                if (food == null || stack.func_77973_b().func_219971_r()) {
                    player.func_213823_a(item.func_225520_U__(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                return true;
            }
            boolean success = false;
            if (food != null && player.func_71043_e(false)) {
                if (item instanceof SuspiciousStewItem) {
                    SoftFluidHolder.susStewBehavior(player, stack, div);
                }
                if (world.field_72995_K) {
                    return true;
                }
                player.func_71024_bL().func_75122_a(food.func_221466_a() / div, food.func_221469_b() / (float)div);
                success = true;
            } else if (item instanceof MilkBucketItem) {
                if (world.field_72995_K) {
                    return true;
                }
                SoftFluidHolder.milkBottleBehavior(player, stack);
                success = true;
            }
            if (success) {
                this.shrink(1);
                player.func_213823_a(item.func_225520_U__(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private static void susStewBehavior(PlayerEntity player, ItemStack stack, int div) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("Effects", 9)) {
            ListNBT listnbt = compoundnbt.func_150295_c("Effects", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                Effect effect;
                int j = 160;
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                if (compoundnbt1.func_150297_b("EffectDuration", 3)) {
                    j = compoundnbt1.func_74762_e("EffectDuration") / div;
                }
                if ((effect = Effect.func_188412_a((int)compoundnbt1.func_74771_c("EffectId"))) == null) continue;
                player.func_195064_c(new EffectInstance(effect, j));
            }
        }
    }

    private static boolean milkBottleBehavior(PlayerEntity player, ItemStack stack) {
        for (EffectInstance effect : player.func_193076_bZ().values()) {
            if (!effect.isCurativeItem(stack)) continue;
            player.func_195063_d(effect.func_188419_a());
            return true;
        }
        return false;
    }

    public static int getLiquidCountFromItem(Item i) {
        if (i == Items.field_151069_bo) {
            return 1;
        }
        if (i == Items.field_151054_z) {
            return 2;
        }
        if (i == Items.field_151133_ar) {
            return 4;
        }
        return 0;
    }

    public static ItemStack getEmptyBottle() {
        return new ItemStack((IItemProvider)Items.field_151069_bo);
    }

    public static ItemStack getEmptyBucket() {
        return new ItemStack((IItemProvider)Items.field_151133_ar);
    }

    public static ItemStack getEmptyBowl() {
        return new ItemStack((IItemProvider)Items.field_151054_z);
    }
}

