/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.fluids;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.fluids.FluidTextures;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.util.DispenserHelper;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;

public class SoftFluidRegistry {
    private static final HashMap<String, SoftFluid> ID_MAP = new HashMap();
    private static final HashMap<Item, SoftFluid> ITEM_MAP = new HashMap();
    private static final HashMap<Fluid, SoftFluid> FLUID_MAP = new HashMap();
    public static final SoftFluid EMPTY = new SoftFluid(new SoftFluid.Builder(Fluids.field_204541_a));
    public static final SoftFluid WATER = SoftFluidRegistry.makeSF(new SoftFluid.Builder((Fluid)Fluids.field_204546_a).containerItem("xercamod:item_glass_of_water", "xercamod:item_glass", 4).containerItem("tea_kettle:water_kettle", "tea_kettle:empty_kettle", 4).food(Items.field_151068_bn));
    public static final SoftFluid LAVA = SoftFluidRegistry.makeSF(new SoftFluid.Builder((Fluid)Fluids.field_204547_b).noTint().bottle("alexsmobs:lava_bottle").bucket(Items.field_151129_at).setBucketSounds(SoundEvents.field_187633_N, SoundEvents.field_187627_L));
    public static final SoftFluid HONEY = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.HONEY_TEXTURE, FluidTextures.HONEY_TEXTURE, "honey").translationKey("fluid.supplementaries.honey").noTint().drink(Items.field_226638_pX_).setSoundsForCategory(SoundEvents.field_226138_eS_, SoundEvents.field_226135_eP_, Items.field_151069_bo).emptyHandContainerItem(Items.field_226639_pY_, 4).setSoundsForCategory(SoundEvents.field_226138_eS_, SoundEvents.field_226135_eP_, Items.field_190931_a).copyTexturesFrom("create:honey").addEqFluid("create:honey").addEqFluid("cyclic:honey").addEqFluid("inspirations:honey"));
    public static final SoftFluid MILK = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.MILK_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "milk").bucket(Items.field_151117_aB).noTint().food(Items.field_151117_aB).translationKey("fluid.supplementaries.milk").copyFlowingTextureFrom("create:milk").addEqFluid("create:milk").addEqFluid("inspirations:milk").bottle("farmersdelight:milk_bottle").bottle("neapolitan:milk_bottle").bottle("fluffy_farmer:bottle_of_milk").bottle("vanillacookbook:milk_bottle").bottle("simplefarming:milk_bottle").bottle("farmersdelight:milk_bottle").containerItem("xercamod:item_glass_of_milk", "xercamod:item_glass", 4).containerItem("frozenup:mug_of_milk", "frozenup:empty_mug", 4));
    public static final SoftFluid MUSHROOM_STEW = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "mushroom_stew").color(16756105).stew(Items.field_151009_A).translationKey(Items.field_151009_A.func_77658_a()).addEqFluid("inspirations:mushroom_stew").copyFlowingTextureFrom("inspirations:mushroom_stew"));
    public static final SoftFluid BEETROOT_SOUP = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "beetroot_soup").color(13186100).stew(Items.field_185165_cW).translationKey(Items.field_185165_cW.func_77658_a()).addEqFluid("inspirations:beetroot_soup").copyFlowingTextureFrom("inspirations:beetroot_soup"));
    public static final SoftFluid RABBIT_STEW = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "rabbit_stew").color(16748623).stew(Items.field_179560_bq).translationKey(Items.field_179560_bq.func_77658_a()).addEqFluid("inspirations:rabbit_stew").copyFlowingTextureFrom("inspirations:rabbit_stew"));
    public static final SoftFluid SUS_STEW = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SOUP_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "suspicious_stew").color(12249183).keepNBTFromItem("Effects").stew(Items.field_222115_pz).translationKey(Items.field_222115_pz.func_77658_a()).copyFlowingTextureFrom("inspirations:mushroom_stew"));
    public static final SoftFluid POTION = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.POTION_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "potion").color(PotionUtils.func_185183_a((Potion)Potions.field_185229_a)).keepNBTFromItem("Potion", "Bottle", "CustomPotionEffects").translationKey(Items.field_151068_bn.func_77658_a()).drink(Items.field_151068_bn).bottle(Items.field_185155_bH).bottle(Items.field_185156_bI).containerItem("minecraft:splash_potion", "inspirations:splash_bottle", 1).containerItem("minecraft:lingering_potion", "inspirations:lingering_bottle", 1).copyTexturesFrom("create:potion").addEqFluid("create:potion").addEqFluid("cofh_core:potion").addEqFluid("immersiveengineering:potion"));
    public static final SoftFluid DRAGON_BREATH = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.DRAGON_BREATH_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "dragon_breath").color(0xFF33FF).luminosity(3).translationKey(Items.field_185157_bK.func_77658_a()).bottle(Items.field_185157_bK));
    public static final SoftFluid XP = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.XP_TEXTURE, FluidTextures.XP_TEXTURE_FLOW, "experience").translationKey("fluid.supplementaries.experience").luminosity(5).noTint().copyTexturesFrom("cyclic:xpjuice").addEqFluid("cyclic:xpjuice").bottle(Items.field_151062_by));
    public static final SoftFluid SLIME = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.SLIME_TEXTURE, FluidTextures.SLIME_TEXTURE, "slime").emptyHandContainerItem(Items.field_151123_aH, 1).noTint().setSoundsForCategory(SoundEvents.field_187884_fr, SoundEvents.field_187872_fl, Items.field_190931_a).addEqFluid("cyclic:slime").translationKey("fluid.supplementaries.slime"));
    public static final SoftFluid GHAST_TEAR = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.MILK_TEXTURE, FluidTextures.POTION_TEXTURE_FLOW, "ghast_tear").color(0xBFF0F0).emptyHandContainerItem(Items.field_151073_bk, 1).translationKey("item.minecraft.ghast_tear"));
    public static final SoftFluid MAGMA_CREAM = SoftFluidRegistry.makeSF(new SoftFluid.Builder(FluidTextures.MAGMA_TEXTURE, FluidTextures.MAGMA_TEXTURE_FLOW, "magma_cream").emptyHandContainerItem(Items.field_151064_bs, 1).color(16752896).setSoundsForCategory(SoundEvents.field_187884_fr, SoundEvents.field_187872_fl, Items.field_190931_a).translationKey("item.minecraft.magma_cream"));

    public static Collection<SoftFluid> getFluids() {
        return ID_MAP.values();
    }

    public static SoftFluid get(String id) {
        return ID_MAP.getOrDefault(id, EMPTY);
    }

    public static SoftFluid fromForgeFluid(Fluid fluid) {
        return FLUID_MAP.getOrDefault(fluid, EMPTY);
    }

    public static SoftFluid fromItem(Item filledContainerItem) {
        return ITEM_MAP.getOrDefault(filledContainerItem, EMPTY);
    }

    public static boolean addContainerToSoftFluid(String softFluidID, Item emptyContainer, Item filledContainer, int itemCapacity, @Nullable SoundEvent fillSound, @Nullable SoundEvent emptySound) {
        SoftFluid s = SoftFluidRegistry.get(softFluidID);
        if (!s.isEmpty() && filledContainer != Items.field_190931_a) {
            SoftFluid.FilledContainerCategory c = s.getFilledContainersMap().computeIfAbsent(emptyContainer, a -> new SoftFluid.FilledContainerCategory(itemCapacity));
            c.setCapacity(itemCapacity);
            c.addItem(filledContainer);
            if (fillSound != null && emptySound != null) {
                c.setSounds(fillSound, emptySound);
            }
            return true;
        }
        return false;
    }

    public static SoftFluid makeSF(SoftFluid.Builder builder) {
        if (builder.isDisabled) {
            return null;
        }
        return new SoftFluid(builder);
    }

    public static SoftFluid register(SoftFluid s) {
        if (s.isDisabled()) {
            return s;
        }
        for (Fluid f : s.getEquivalentFluids()) {
            if (!FLUID_MAP.containsKey(f)) continue;
            SoftFluid old = FLUID_MAP.get(f);
            if (old.isCustom) continue;
            ID_MAP.remove(old.getID());
            ITEM_MAP.remove(old.getFilledContainer(Items.field_151133_ar));
        }
        SoftFluidRegistry.registerUnchecked(s);
        return s;
    }

    private static void registerUnchecked(SoftFluid ... fluids) {
        Arrays.stream(fluids).forEach(s -> {
            s.getEquivalentFluids().forEach(f -> FLUID_MAP.put((Fluid)f, (SoftFluid)s));
            s.getAllFilledContainers().forEach(i -> ITEM_MAP.put((Item)i, (SoftFluid)s));
            ID_MAP.put(s.getID(), (SoftFluid)s);
            DispenserHelper.registerFluidBehavior(s);
        });
    }

    private static void convertAndRegisterAllForgeFluids() {
        for (Fluid f : ForgeRegistries.FLUIDS) {
            try {
                if (f == null || f instanceof FlowingFluid && ((FlowingFluid)f).func_210198_f() != f || f instanceof ForgeFlowingFluid.Flowing || f == Fluids.field_204541_a || FLUID_MAP.containsKey(f)) continue;
                SoftFluidRegistry.registerUnchecked(new SoftFluid(new SoftFluid.Builder(f)));
            }
            catch (Exception exception) {}
        }
    }

    public static void init() {
        SoftFluidRegistry.registerUnchecked(WATER, LAVA, HONEY, MILK, MUSHROOM_STEW, MAGMA_CREAM, SUS_STEW, BEETROOT_SOUP, RABBIT_STEW, POTION, DRAGON_BREATH, XP, SLIME, GHAST_TEAR);
        SoftFluidRegistry.convertAndRegisterAllForgeFluids();
    }
}

