/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.util;

import java.util.Map;
import net.mehvahdjukaar.selene.fluids.ISoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DispenserHelper {
    public static final DefaultDispenseItemBehavior PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final DefaultDispenseItemBehavior SHOOT_BEHAVIOR = new DefaultDispenseItemBehavior();
    public static final DefaultDispenseItemBehavior SPAWN_EGG_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            type.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack.func_190918_g(1);
            return stack;
        }
    };

    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        DispenserBlock.func_199774_a((IItemProvider)behavior.item, (IDispenseItemBehavior)behavior);
    }

    public static void registerSpawnEggBehavior(IItemProvider egg) {
        DispenserBlock.func_199774_a((IItemProvider)egg, (IDispenseItemBehavior)SPAWN_EGG_BEHAVIOR);
    }

    public static void registerPlaceBlockBehavior(IItemProvider block) {
        DispenserBlock.func_199774_a((IItemProvider)block, (IDispenseItemBehavior)PLACE_BLOCK_BEHAVIOR);
    }

    public static void registerFluidBehavior(SoftFluid f) {
        Map<Item, SoftFluid.FilledContainerCategory> map = f.getFilledContainersMap();
        for (Item empty : map.keySet()) {
            if (empty != Items.field_190931_a) {
                DispenserHelper.registerCustomBehavior(new FillFluidHolderBehavior(empty));
            }
            for (Item full : map.get(empty).getItems()) {
                if (full == Items.field_190931_a) continue;
                DispenserHelper.registerCustomBehavior(new FillFluidHolderBehavior(full));
            }
        }
    }

    private static ItemStack fillItemInDispenser(IBlockSource source, ItemStack empty, ItemStack filled) {
        empty.func_190918_g(1);
        if (empty.func_190926_b()) {
            return filled.func_77946_l();
        }
        if (!DispenserHelper.MergeDispenserItem((DispenserTileEntity)source.func_150835_j(), filled)) {
            SHOOT_BEHAVIOR.dispense(source, filled.func_77946_l());
        }
        return empty;
    }

    private static boolean MergeDispenserItem(DispenserTileEntity te, ItemStack filled) {
        NonNullList stacks = te.field_146022_i;
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            ItemStack s = (ItemStack)stacks.get(i);
            if (!s.func_190926_b() && (s.func_77973_b() != filled.func_77973_b() || s.func_77976_d() <= s.func_190916_E())) continue;
            filled.func_190917_f(s.func_190916_E());
            te.func_70299_a(i, filled);
            return true;
        }
        return false;
    }

    public static class PlaceBlockDispenseBehavior
    extends OptionalDispenseBehavior {
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            this.func_239796_a_(false);
            Item item = stack.func_77973_b();
            if (item instanceof BlockItem) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                Direction direction1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? direction : Direction.UP;
                ActionResultType result = ((BlockItem)item).func_195942_a((BlockItemUseContext)new DirectionalPlaceContext((World)source.func_197524_h(), blockpos, direction, stack, direction1));
                this.func_239796_a_(result.func_226246_a_());
            }
            return stack;
        }
    }

    public static class FillFluidHolderBehavior
    extends AdditionalDispenserBehavior {
        public FillFluidHolderBehavior(Item item) {
            super(item);
        }

        @Override
        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (te instanceof ISoftFluidHolder) {
                ItemStack returnStack;
                SoftFluidHolder tank;
                ISoftFluidHolder tile = (ISoftFluidHolder)te;
                if (tile.canInteractWithFluidHolder() && !(tank = tile.getSoftFluidHolder()).isFull() && (returnStack = tank.interactWithItem(stack, (World)world, blockpos, false)) != null) {
                    te.func_70296_d();
                    return ActionResult.func_226248_a_((Object)returnStack);
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
    }

    public static class AddItemToInventoryBehavior
    extends AdditionalDispenserBehavior {
        public AddItemToInventoryBehavior(Item item) {
            super(item);
        }

        @Override
        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (te instanceof ISidedInventory) {
                ISidedInventory tile = (ISidedInventory)te;
                if (tile.func_94041_b(0, stack)) {
                    if (tile.func_191420_l()) {
                        tile.func_70299_a(0, stack.func_77979_a(1));
                    } else {
                        tile.func_70301_a(0).func_190917_f(1);
                        stack.func_190918_g(1);
                    }
                    return ActionResult.func_226248_a_((Object)stack);
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
    }

    public static abstract class AdditionalDispenserBehavior
    implements IDispenseItemBehavior {
        private final IDispenseItemBehavior fallback;
        private final Item item;

        protected AdditionalDispenserBehavior(Item item) {
            this.item = item;
            this.fallback = (IDispenseItemBehavior)DispenserBlock.field_149943_a.get(item);
        }

        public final ItemStack dispense(IBlockSource source, ItemStack stack) {
            try {
                ActionResult<ItemStack> result = this.customBehavior(source, stack);
                ActionResultType type = result.func_188397_a();
                if (type != ActionResultType.PASS) {
                    boolean success = type.func_226246_a_();
                    this.playSound(source, success);
                    this.playAnimation(source, (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                    if (success) {
                        ItemStack resultStack = (ItemStack)result.func_188398_b();
                        if (resultStack.func_77973_b() == stack.func_77973_b()) {
                            return resultStack;
                        }
                        return DispenserHelper.fillItemInDispenser(source, stack, (ItemStack)result.func_188398_b());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.fallback.dispense(source, stack);
        }

        protected abstract ActionResult<ItemStack> customBehavior(IBlockSource var1, ItemStack var2);

        protected void playSound(IBlockSource source, boolean success) {
            source.func_197524_h().func_217379_c(success ? 1000 : 1001, source.func_180699_d(), 0);
        }

        protected void playAnimation(IBlockSource source, Direction direction) {
            source.func_197524_h().func_217379_c(2000, source.func_180699_d(), direction.func_176745_a());
        }
    }
}

