/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.corelib.net.NetUtils;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = new ResourceLocation("camera", "textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = new ResourceLocation("camera", "textures/gui/zoom.png");
    public static final float MAX_FOV = 90.0f;
    public static final float MIN_FOV = 5.0f;
    private Minecraft mc = Minecraft.getInstance();
    private boolean inCameraMode = false;
    private float fov = 0.0f;
    private ResourceLocation currentShader;

    @SubscribeEvent
    public void renderOverlay(RenderGuiOverlayEvent.Pre event) {
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        this.mc.options.setCameraType(CameraType.FIRST_PERSON);
        this.setShader(this.getShader((Player)this.mc.player));
        this.drawViewFinder(event.getGuiGraphics());
        this.drawZoom(event.getGuiGraphics(), this.getFOVPercentage());
    }

    private void drawViewFinder(GuiGraphics guiGraphics) {
        float hnew;
        float wnew;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VIEWFINDER);
        float imageWidth = 192.0f;
        float imageHeight = 100.0f;
        BufferBuilder buffer = Tesselator.getInstance().getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float ws = this.mc.getWindow().getGuiScaledWidth();
        float hs = this.mc.getWindow().getGuiScaledHeight();
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        buffer.vertex(matrix, left, top, 0.0f).uv(0.0f, 0.0f).endVertex();
        buffer.vertex(matrix, left, top + hnew, 0.0f).uv(0.0f, 0.390625f).endVertex();
        buffer.vertex(matrix, left + wnew, top + hnew, 0.0f).uv(0.75f, 0.390625f).endVertex();
        buffer.vertex(matrix, left + wnew, top, 0.0f).uv(0.75f, 0.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)buffer.end());
    }

    private void drawZoom(GuiGraphics guiGraphics, float percent) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ZOOM);
        int zoomWidth = 112;
        int zoomHeight = 20;
        BufferBuilder buffer = Tesselator.getInstance().getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        int width = this.mc.getWindow().getGuiScaledWidth();
        int height = this.mc.getWindow().getGuiScaledHeight();
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        buffer.vertex(matrix, (float)left, (float)top, 0.0f).uv(0.0f, 0.0f).endVertex();
        buffer.vertex(matrix, (float)left, (float)(top + zoomHeight / 2), 0.0f).uv(0.0f, 0.078125f).endVertex();
        buffer.vertex(matrix, (float)(left + zoomWidth), (float)(top + zoomHeight / 2), 0.0f).uv(0.875f, 0.078125f).endVertex();
        buffer.vertex(matrix, (float)(left + zoomWidth), (float)top, 0.0f).uv(0.875f, 0.0f).endVertex();
        int percWidth = (int)(Math.max(Math.min((double)percent, 1.0), 0.0) * (double)zoomWidth);
        buffer.vertex(matrix, (float)left, (float)top, 0.0f).uv(0.0f, 0.078125f).endVertex();
        buffer.vertex(matrix, (float)left, (float)(top + zoomHeight / 2), 0.0f).uv(0.0f, 0.15625f).endVertex();
        buffer.vertex(matrix, (float)(left + percWidth), (float)(top + zoomHeight / 2), 0.0f).uv(0.875f * percent, 0.15625f).endVertex();
        buffer.vertex(matrix, (float)(left + percWidth), (float)top, 0.0f).uv(0.875f * percent, 0.078125f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)buffer.end());
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(ScreenEvent.Opening event) {
        if (this.inCameraMode && event.getScreen() instanceof PauseScreen) {
            NetUtils.sendToServer(Main.SIMPLE_CHANNEL, new MessageDisableCameraMode());
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.getItem().equals(Main.CAMERA.get())) continue;
            return Shaders.getShader(((CameraItem)((Object)Main.CAMERA.get())).getShader(stack));
        }
        return null;
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            if (this.currentShader != null) {
                this.mc.gameRenderer.shutdownEffect();
            }
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.gameRenderer.loadEffect(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (player == this.mc.player) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!(stack.getItem() instanceof CameraItem) || !((CameraItem)((Object)Main.CAMERA.get())).isActive(stack)) continue;
            player.startUsingItem(hand);
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        if (player == this.mc.player) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        event.getEntity().stopUsingItem();
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        if (event.getScrollDeltaY() == 0.0) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        this.fov = event.getScrollDeltaY() < 0.0 ? Math.min(this.fov + 5.0f, 90.0f) : Math.max(this.fov - 5.0f, 5.0f);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onFOVModifierEvent(ViewportEvent.ComputeFov event) {
        if (!this.inCameraMode) {
            this.fov = (float)event.getFOV();
            return;
        }
        this.mc.player.setPos(this.mc.player.getX(), this.mc.player.getY() + 1.0E-9, this.mc.player.getZ());
        event.setFOV((double)this.fov);
    }

    public float getFOVPercentage() {
        return 1.0f - (this.fov - 5.0f) / 85.0f;
    }

    private ItemStack getActiveCamera() {
        if (this.mc.player == null) {
            return null;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = this.mc.player.getItemInHand(hand);
            if (!stack.getItem().equals(Main.CAMERA.get()) || !((CameraItem)((Object)Main.CAMERA.get())).isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

