/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.energy;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyUtils {
    public static int pushEnergy(IEnergyStorage provider, IEnergyStorage receiver, int maxAmount) {
        int energySim = provider.extractEnergy(maxAmount, true);
        int receivedSim = receiver.receiveEnergy(energySim, true);
        int energy = provider.extractEnergy(receivedSim, false);
        receiver.receiveEnergy(energy, false);
        return energy;
    }

    @Nullable
    public static IEnergyStorage getEnergyStorage(LevelAccessor world, BlockPos pos, Direction side) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te == null) {
            return null;
        }
        return (IEnergyStorage)te.getCapability(Capabilities.ENERGY, side.getOpposite()).orElse(null);
    }

    @Nullable
    public static IEnergyStorage getEnergyStorageOffset(LevelAccessor world, BlockPos pos, Direction side) {
        return EnergyUtils.getEnergyStorage(world, pos.relative(side), side.getOpposite());
    }
}

