/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.maxhenkel.camera.corelib.client.RenderUtils;
import de.maxhenkel.camera.corelib.helpers.AbstractStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class WrappedFluidStack
extends AbstractStack<FluidStack> {
    public WrappedFluidStack(FluidStack stack) {
        super(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics guiGraphics, int x, int y) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)((FluidStack)this.stack).getFluid());
        TextureAtlasSprite texture = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(extensions.getStillTexture((FluidStack)this.stack));
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        int color = extensions.getTintColor((FluidStack)this.stack);
        RenderSystem.setShaderColor((float)RenderUtils.getRedFloat(color), (float)RenderUtils.getGreenFloat(color), (float)RenderUtils.getBlueFloat(color), (float)RenderUtils.getAlphaFloat(color));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.atlasLocation());
        WrappedFluidStack.fluidBlit(guiGraphics, x, y, 16, 16, texture, color);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            if (BuiltInRegistries.FLUID.containsValue((Object)((FluidStack)this.stack).getFluid())) {
                ResourceLocation registryName = BuiltInRegistries.FLUID.getKey((Object)((FluidStack)this.stack).getFluid());
                tooltip.add((Component)Component.literal((String)registryName.toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
            if (((FluidStack)this.stack).hasTag()) {
                tooltip.add((Component)Component.translatable((String)"item.nbt_tags", (Object[])new Object[]{((FluidStack)this.stack).getTag().getAllKeys().size()}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }

    @Override
    public Component getDisplayName() {
        return Component.literal((String)"").append(((FluidStack)this.stack).getDisplayName()).withStyle(((FluidStack)this.stack).getFluid().getFluidType().getRarity().getStyleModifier());
    }

    @Override
    public boolean isEmpty() {
        return ((FluidStack)this.stack).isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fluidBlit(GuiGraphics guiGraphics, int x, int y, int width, int height, TextureAtlasSprite sprite, int color) {
        WrappedFluidStack.innerBlit(guiGraphics.pose().last().pose(), x, x + width, y, y + height, sprite.getU0(), sprite.getU1(), sprite.getV0(), (sprite.getV1() - sprite.getV0()) * (float)height / 16.0f + sprite.getV0(), color);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, float minU, float maxU, float minV, float maxV, int color) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(matrix, (float)x1, (float)y2, 0.0f).uv(minU, maxV).color(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).endVertex();
        bufferbuilder.vertex(matrix, (float)x2, (float)y2, 0.0f).uv(maxU, maxV).color(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).endVertex();
        bufferbuilder.vertex(matrix, (float)x2, (float)y1, 0.0f).uv(maxU, minV).color(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).endVertex();
        bufferbuilder.vertex(matrix, (float)x1, (float)y1, 0.0f).uv(minU, minV).color(RenderUtils.getRed(color), RenderUtils.getGreen(color), RenderUtils.getBlue(color), 255).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
    }
}

