/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageProcessor;
import de.maxhenkel.camera.corelib.net.Message;
import java.awt.image.BufferedImage;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.neoforge.network.NetworkEvent;

public class MessageUploadCustomImage
implements Message<MessageUploadCustomImage> {
    private UUID uuid;

    public MessageUploadCustomImage() {
    }

    public MessageUploadCustomImage(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
        BufferedImage image = ClientImageUploadManager.getAndRemoveImage(this.uuid);
        if (image == null) {
            return;
        }
        ImageProcessor.sendScreenshotThreaded(this.uuid, image);
    }

    @Override
    public MessageUploadCustomImage fromBytes(FriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }
}

