/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.ResizeFrameScreen;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ImageEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> ID = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Direction> FACING = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Integer> WIDTH = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> HEIGHT = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final AABB NULL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double THICKNESS = 0.0625;
    private static final int MAX_WIDTH = 8;
    private static final int MAX_HEIGHT = 8;

    public ImageEntity(EntityType type, Level world) {
        super(type, world);
        this.setBoundingBox(NULL_AABB);
    }

    public ImageEntity(Level world) {
        this((EntityType)Main.IMAGE_ENTITY_TYPE.get(), world);
    }

    public ImageEntity(Level world, double x, double y, double z) {
        this((EntityType)Main.IMAGE_ENTITY_TYPE.get(), world);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void tick() {
        this.updateBoundingBox();
        super.tick();
        this.checkValid();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && this.canModify(player)) {
            if (this.level().isClientSide) {
                this.openClientGui();
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (this.hasImage()) {
            if (heldItem.isEmpty()) {
                ItemStack containedItem = this.removeImage();
                player.setItemInHand(hand, containedItem);
                this.playRemoveSound();
            } else {
                ItemStack image = this.removeImage();
                this.playRemoveSound();
                if (!player.addItem(image)) {
                    this.dropItem(image);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!(heldItem.getItem() instanceof ImageItem)) {
            return InteractionResult.PASS;
        }
        UUID imageID = ImageData.getImageID(heldItem);
        if (imageID == null) {
            return InteractionResult.PASS;
        }
        ItemStack frameStack = heldItem.split(1);
        this.setItem(frameStack);
        this.setImageUUID(imageID);
        this.playAddSound();
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public boolean canModify(Player player) {
        if (!player.getAbilities().mayBuild) {
            return false;
        }
        if (!((Boolean)Main.SERVER_CONFIG.frameOnlyOwnerModify.get()).booleanValue()) {
            return true;
        }
        if (player.isCreative() && player.hasPermissions(1)) {
            return true;
        }
        if (!this.getOwner().isPresent()) {
            return true;
        }
        return this.getOwner().get().equals(player.getUUID());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui() {
        Minecraft.getInstance().setScreen((Screen)new ResizeFrameScreen(this.getUUID()));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide) {
            return true;
        }
        if (!(source.getDirectEntity() instanceof Player)) {
            return false;
        }
        if (!this.canModify((Player)source.getDirectEntity())) {
            return false;
        }
        if (this.hasImage()) {
            ItemStack image = this.removeImage();
            if (!this.level().isClientSide) {
                this.playRemoveSound();
                this.dropItem(image);
            }
            return true;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.removeFrame(source.getEntity());
        return true;
    }

    public boolean isValid() {
        return this.level().noCollision((Entity)this, this.getBoundingBox()) && this.level().getEntitiesOfClass(ImageEntity.class, this.getBoundingBox().contract(this.getFacing().getStepX() == 0 ? 0.125 : 0.0, this.getFacing().getStepY() == 0 ? 0.125 : 0.0, this.getFacing().getStepZ() == 0 ? 0.125 : 0.0), image -> image != this).isEmpty();
    }

    public void checkValid() {
        if (!this.isValid()) {
            this.removeFrame();
        }
    }

    public void onBroken(Entity entity) {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                return;
            }
        }
        this.dropItem(new ItemStack((ItemLike)Main.FRAME_ITEM.get()));
        if (this.hasImage()) {
            this.dropItem(this.removeImage());
        }
    }

    public void resize(MessageResizeFrame.Direction direction, boolean larger) {
        int amount = larger ? 1 : -1;
        switch (direction) {
            case UP: {
                this.setFrameHeight(this.getFrameHeight() + amount);
                break;
            }
            case DOWN: {
                if (!this.setFrameHeight(this.getFrameHeight() + amount)) break;
                this.setImagePosition(this.blockPosition().relative(Direction.DOWN, amount));
                break;
            }
            case RIGHT: {
                this.setFrameWidth(this.getFrameWidth() + amount);
                break;
            }
            case LEFT: {
                if (!this.setFrameWidth(this.getFrameWidth() + amount)) break;
                this.setImagePosition(this.blockPosition().relative(this.getResizeOffset(), amount));
            }
        }
    }

    private Direction getResizeOffset() {
        switch (this.getFacing()) {
            default: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.EAST;
            }
            case SOUTH: 
        }
        return Direction.WEST;
    }

    public ItemStack getPickedResult(HitResult target) {
        if (this.hasImage()) {
            return this.getItem().copy();
        }
        return new ItemStack((ItemLike)Main.FRAME_ITEM.get());
    }

    private void updateBoundingBox() {
        Direction facing = this.getFacing();
        if (facing.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot((float)facing.get2DDataValue() * 90.0f);
        } else {
            this.setXRot(-90.0f * (float)facing.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox() {
        return this.calculateBoundingBox(this.blockPosition(), this.getFacing(), this.getFrameWidth(), this.getFrameHeight());
    }

    private AABB calculateBoundingBox(BlockPos pos, Direction facing, double width, double height) {
        switch (facing) {
            default: {
                return new AABB((double)pos.getX() + 1.0, (double)pos.getY(), (double)pos.getZ() + 1.0 - 0.0625, (double)pos.getX() - width + 1.0, (double)pos.getY() + height, (double)pos.getZ() + 1.0);
            }
            case SOUTH: {
                return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + width, (double)pos.getY() + height, (double)pos.getZ() + 0.0625);
            }
            case WEST: {
                return new AABB((double)pos.getX() + 1.0 - 0.0625, (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + height, (double)pos.getZ() + width);
            }
            case EAST: 
        }
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ() + 1.0, (double)pos.getX() + 0.0625, (double)pos.getY() + height, (double)pos.getZ() - width + 1.0);
    }

    public BlockPos getCenterPosition() {
        Vec3 center = this.getBoundingBox().getCenter();
        return new BlockPos.MutableBlockPos(center.x, center.y, center.z);
    }

    @Nullable
    public ItemEntity dropItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        BlockPos center = this.getCenterPosition();
        ItemEntity entityitem = new ItemEntity(this.level(), (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, stack);
        entityitem.setDefaultPickUpDelay();
        this.level().addFreshEntity((Entity)entityitem);
        return entityitem;
    }

    public void removeFrame(Entity source) {
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.onBroken(source);
            this.kill();
        }
    }

    public void removeFrame() {
        this.removeFrame(null);
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void playPlaceSound() {
        this.level().playSound(null, this.getCenterPosition(), SoundEvents.PAINTING_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playAddSound() {
        this.level().playSound(null, this.getCenterPosition(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playRemoveSound() {
        this.level().playSound(null, this.getCenterPosition(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.entityData.get(OWNER);
    }

    public void setOwner(UUID owner) {
        this.entityData.set(OWNER, Optional.ofNullable(owner));
    }

    public Optional<UUID> getImageUUID() {
        return (Optional)this.entityData.get(ID);
    }

    public void setImageUUID(UUID uuid) {
        this.entityData.set(ID, Optional.ofNullable(uuid));
    }

    public int getFrameWidth() {
        return (Integer)this.entityData.get(WIDTH);
    }

    public int getFrameHeight() {
        return (Integer)this.entityData.get(HEIGHT);
    }

    public boolean setFrameWidth(int width) {
        if (width <= 0) {
            width = 1;
        } else if (width > 8) {
            width = 8;
        }
        int oldWidth = this.getFrameWidth();
        this.entityData.set(WIDTH, (Object)width);
        return oldWidth != width;
    }

    public boolean setFrameHeight(int height) {
        if (height <= 0) {
            height = 1;
        } else if (height > 8) {
            height = 8;
        }
        int oldHeight = this.getFrameHeight();
        this.entityData.set(HEIGHT, (Object)height);
        return oldHeight != height;
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.entityData.set(ITEM, (Object)stack);
    }

    public void setImagePosition(BlockPos position) {
        this.moveTo((double)position.getX() + 0.5, position.getY(), (double)position.getZ() + 0.5, this.getYRot(), this.getXRot());
        this.updateBoundingBox();
    }

    public void setFacing(Direction facing) {
        this.entityData.set(FACING, (Object)facing);
        this.updateBoundingBox();
    }

    public Direction getFacing() {
        return (Direction)this.entityData.get(FACING);
    }

    private boolean hasImage() {
        return !this.getItem().isEmpty();
    }

    private ItemStack removeImage() {
        ItemStack item = this.getItem();
        this.setItem(ItemStack.EMPTY);
        this.setImageUUID(null);
        return item;
    }

    protected void defineSynchedData() {
        this.entityData.define(ID, Optional.empty());
        this.entityData.define(FACING, (Object)Direction.NORTH);
        this.entityData.define(WIDTH, (Object)1);
        this.entityData.define(HEIGHT, (Object)1);
        this.entityData.define(ITEM, (Object)ItemStack.EMPTY);
        this.entityData.define(OWNER, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        if (this.getImageUUID().isPresent()) {
            compound.putUUID("image_id", this.getImageUUID().get());
        }
        if (this.getOwner().isPresent()) {
            compound.putUUID("owner", this.getOwner().get());
        }
        compound.putInt("facing", this.getFacing().get3DDataValue());
        compound.putInt("width", this.getFrameWidth());
        compound.putInt("height", this.getFrameHeight());
        compound.put("item", (Tag)this.getItem().save(new CompoundTag()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("image_id")) {
            this.setImageUUID(compound.getUUID("image_id"));
        }
        if (compound.contains("owner")) {
            this.setOwner(compound.getUUID("owner"));
        }
        this.setFacing(Direction.from3DDataValue((int)compound.getInt("facing")));
        this.setFrameWidth(compound.getInt("width"));
        this.setFrameHeight(compound.getInt("height"));
        this.setItem(ItemStack.of((CompoundTag)compound.getCompound("item")));
        this.updateBoundingBox();
    }
}

