/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.AlbumInventoryContainer;
import de.maxhenkel.camera.gui.AlbumScreen;
import de.maxhenkel.camera.inventory.AlbumInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AlbumItem
extends Item {
    public AlbumItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        final ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown()) {
            if (!playerIn.level().isClientSide && playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                serverPlayer.openMenu(new MenuProvider(){

                    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                        return new AlbumInventoryContainer(id, (Container)playerInventory, new AlbumInventory(stack));
                    }

                    public Component getDisplayName() {
                        return Component.translatable((String)AlbumItem.this.getDescriptionId());
                    }
                });
            }
        } else {
            AlbumItem.openAlbum(playerIn, stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static void openAlbum(Player player, ItemStack album) {
        List<UUID> images;
        if (player.level().isClientSide && !(images = ((AlbumItem)((Object)Main.ALBUM.get())).getImages(album)).isEmpty()) {
            AlbumItem.openClientGui(images);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openClientGui(List<UUID> images) {
        Minecraft.getInstance().setScreen((Screen)new AlbumScreen(images));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.getLevel();
        BlockState blockstate = world.getBlockState(blockpos = context.getClickedPos());
        if (blockstate.is(Blocks.LECTERN)) {
            return LecternBlock.tryPlaceBook((Entity)context.getPlayer(), (Level)world, (BlockPos)blockpos, (BlockState)blockstate, (ItemStack)context.getItemInHand()) ? InteractionResult.sidedSuccess((boolean)world.isClientSide) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public List<UUID> getImages(ItemStack stack) {
        if (stack.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<UUID> images = new ArrayList<UUID>();
        AlbumInventory inventory = new AlbumInventory(stack);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack s = inventory.getItem(i);
            UUID uuid = ImageData.getImageID(s);
            if (uuid == null) continue;
            images.add(uuid);
        }
        return images;
    }
}

