/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.net.Message;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.neoforge.network.NetworkEvent;

public class MessagePartialImage
implements Message<MessagePartialImage> {
    private UUID imgUUID;
    private int offset;
    private int length;
    private byte[] bytes;

    public MessagePartialImage() {
    }

    public MessagePartialImage(UUID imgUUID, int offset, int length, byte[] bytes) {
        this.imgUUID = imgUUID;
        this.offset = offset;
        this.length = length;
        this.bytes = bytes;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        Main.PACKET_MANAGER.addBytes(context.getSender(), this.imgUUID, this.offset, this.length, this.bytes);
    }

    @Override
    public MessagePartialImage fromBytes(FriendlyByteBuf buf) {
        this.imgUUID = buf.readUUID();
        this.offset = buf.readInt();
        this.length = buf.readInt();
        this.bytes = buf.readByteArray();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.imgUUID);
        buf.writeInt(this.offset);
        buf.writeInt(this.length);
        buf.writeByteArray(this.bytes);
    }
}

