/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.cable.EnumConnectType;
import com.lothrazar.storagenetwork.block.main.TileMain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCableWithFacing
extends TileConnectable {
    Direction direction = null;

    public TileCableWithFacing(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getFacingPosition() {
        return this.m_58899_().m_142300_(this.direction);
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    protected boolean isValidLinkNeighbor(Direction facing) {
        if (facing == null) {
            return false;
        }
        if (!TileMain.isTargetAllowed(this.f_58857_.m_8055_(this.f_58858_.m_142300_(facing)))) {
            return false;
        }
        BlockEntity neighbor = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
        return neighbor != null && neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_()).orElse(null) != null;
    }

    public void findNewDirection() {
        for (Direction facing : Direction.values()) {
            if (!this.isValidLinkNeighbor(facing)) continue;
            this.setDirection(facing);
            return;
        }
        this.setDirection(null);
    }

    public void rotate() {
        Direction previous = this.direction;
        List<Direction> targetFaces = Arrays.asList(Direction.values());
        Collections.shuffle(targetFaces);
        for (Direction facing : Direction.values()) {
            TileMain mainNode;
            if (previous == facing || !this.isValidLinkNeighbor(facing)) continue;
            this.setDirection(facing);
            this.m_6596_();
            if (previous != this.direction && (mainNode = this.getTileMain()) != null) {
                mainNode.refreshNetwork();
            }
            return;
        }
    }

    public void refreshDirection() {
        if (this.getDirection() == null) {
            this.findNewDirection();
            if (this.getDirection() != null) {
                BlockState newState = BlockCable.cleanBlockState(this.m_58900_());
                newState = (BlockState)newState.m_61124_((Property)BlockCable.FACING_TO_PROPERTY_MAP.get(this.getDirection()), (Comparable)((Object)EnumConnectType.INVENTORY));
                this.f_58857_.m_46597_(this.f_58858_, newState);
            }
        }
    }

    public TileMain getTileMain() {
        if (this.getMain() == null) {
            return null;
        }
        return this.getMain().getTileEntity(TileMain.class);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.direction = compound.m_128441_("direction") ? Direction.values()[compound.m_128451_("direction")] : null;
    }

    @Override
    public CompoundTag save(CompoundTag compound) {
        if (this.direction != null) {
            compound.m_128405_("direction", this.direction.ordinal());
        }
        return super.save(compound);
    }
}

