/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability;

import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.capability.handler.UpgradesItemStackHandler;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityConnectableAutoIO
implements INBTSerializable<CompoundTag>,
IConnectableItemAutoIO {
    public final IConnectable connectable;
    public EnumStorageDirection direction;
    public final UpgradesItemStackHandler upgrades = new UpgradesItemStackHandler();
    private final FilterItemStackHandler filters = new FilterItemStackHandler();
    private ItemStack operationStack = ItemStack.f_41583_;
    private int operationLimit = 0;
    private boolean operationMustBeSmaller = true;
    private int priority = 0;
    private Direction inventoryFace;
    private boolean needsRedstone = false;

    CapabilityConnectableAutoIO(EnumStorageDirection direction) {
        this.connectable = new CapabilityConnectable();
        this.direction = direction;
    }

    @Override
    public void toggleNeedsRedstone() {
        this.needsRedstone = !this.needsRedstone;
    }

    @Override
    public boolean needsRedstone() {
        return this.needsRedstone;
    }

    @Override
    public void needsRedstone(boolean in) {
        this.needsRedstone = in;
    }

    public FilterItemStackHandler getFilter() {
        return this.filters;
    }

    public List<ItemStack> getStoredStacks(boolean isFiltered) {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.m_41619_() || isFiltered && this.filters.isStackFiltered(stack)) continue;
            result.add(stack.m_41777_());
        }
        return result;
    }

    public void setPriority(int value) {
        this.priority = value;
    }

    public void setFilter(int value, ItemStack stack) {
        this.filters.setStackInSlot(value, stack);
        this.filters.getStacks().set(value, stack);
    }

    public CapabilityConnectableAutoIO(BlockEntity tile, EnumStorageDirection direction) {
        this.connectable = (IConnectable)tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
        this.direction = direction;
        if (direction == EnumStorageDirection.OUT) {
            this.filters.setIsAllowlist(true);
        } else {
            this.filters.setIsAllowlist(false);
        }
    }

    public void setInventoryFace(Direction inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public CompoundTag serializeNBT() {
        CompoundTag result = new CompoundTag();
        result.m_128365_("upgrades", (Tag)this.upgrades.serializeNBT());
        result.m_128365_("filters", (Tag)this.filters.serializeNBT());
        CompoundTag operation = new CompoundTag();
        operation.m_128365_("stack", (Tag)this.operationStack.serializeNBT());
        operation.m_128379_("mustBeSmaller", this.operationMustBeSmaller);
        operation.m_128405_("limit", this.operationLimit);
        result.m_128365_("operation", (Tag)operation);
        result.m_128405_("prio", this.priority);
        if (this.inventoryFace != null) {
            result.m_128359_("inventoryFace", this.inventoryFace.toString());
        }
        result.m_128379_("needsRedstone", this.needsRedstone());
        return result;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag filters;
        CompoundTag upgrades = nbt.m_128469_("upgrades");
        if (upgrades != null) {
            this.upgrades.deserializeNBT(upgrades);
        }
        if ((filters = nbt.m_128469_("filters")) != null) {
            this.filters.deserializeNBT(filters);
        }
        CompoundTag operation = nbt.m_128469_("operation");
        this.operationStack = ItemStack.f_41583_;
        if (operation != null) {
            this.operationLimit = operation.m_128451_("limit");
            this.operationMustBeSmaller = operation.m_128471_("mustBeSmaller");
            if (operation.m_128441_("stack")) {
                this.operationStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)operation.m_128423_("stack")));
            }
        }
        this.priority = nbt.m_128451_("prio");
        if (nbt.m_128441_("inventoryFace")) {
            this.inventoryFace = Direction.m_122402_((String)nbt.m_128461_("inventoryFace"));
        }
        this.needsRedstone(nbt.m_128471_("needsRedstone"));
    }

    @Override
    public EnumStorageDirection ioDirection() {
        return this.direction;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getTransferRate() {
        return this.upgrades.getUpgradesOfType(SsnRegistry.STACK_UPGRADE) > 0 ? 64 : 4;
    }

    @Override
    public ItemStack insertStack(ItemStack stack, boolean simulate) {
        if (this.direction == EnumStorageDirection.IN) {
            return stack;
        }
        if (this.inventoryFace == null) {
            return stack;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
    }

    public List<ItemStack> getStacksForFilter() {
        if (this.inventoryFace == null) {
            return Collections.emptyList();
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.m_41619_() || this.filters.exactStackAlreadyInList(stack)) continue;
            result.add(stack.m_41777_());
            if (result.size() < 18) continue;
            return result;
        }
        return result;
    }

    @Override
    public ItemStack extractNextStack(int size, boolean simulate) {
        if (this.direction == EnumStorageDirection.OUT) {
            return ItemStack.f_41583_;
        }
        if (this.inventoryFace == null) {
            return ItemStack.f_41583_;
        }
        DimPos inventoryPos = this.connectable.getPos().offset(this.inventoryFace);
        IItemHandler itemHandler = (IItemHandler)inventoryPos.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.inventoryFace.m_122424_());
        if (itemHandler == null) {
            return ItemStack.f_41583_;
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack == null || stack.m_41619_() || this.filters.isStackFiltered(stack)) continue;
            int extractSize = Math.min(size, stack.m_41613_());
            return itemHandler.extractItem(slot, extractSize, simulate);
        }
        return ItemStack.f_41583_;
    }

    private int countOps() {
        return 0;
    }

    private boolean doesPassOperationFilterLimit(TileMain root) {
        if (this.countOps() < 1) {
            return true;
        }
        if (this.operationStack == null || this.operationStack.m_41619_()) {
            return true;
        }
        int availableStack = root.getAmount(new ItemStackMatcher(this.operationStack, this.filters.tags, this.filters.nbt));
        if (this.operationMustBeSmaller) {
            return this.operationLimit >= availableStack;
        }
        return this.operationLimit < availableStack;
    }

    @Override
    public boolean runNow(DimPos connectablePos, TileMain main) {
        int speed = Math.max(this.upgrades.getUpgradesOfType(SsnRegistry.SPEED_UPGRADE) + 1, 1);
        int speedRatio = 30 / speed;
        if (speedRatio <= 1) {
            speedRatio = 1;
        }
        boolean cooldownOk = connectablePos.getWorld().m_46467_() % (long)speedRatio == 0L;
        boolean operationLimitOk = this.doesPassOperationFilterLimit(main);
        return cooldownOk && operationLimitOk;
    }

    @Override
    public List<IItemStackMatcher> getAutoExportList() {
        return this.filters.getStackMatchers();
    }

    @Override
    public boolean isStockMode() {
        return false;
    }

    @Override
    public Direction facingInventory() {
        return this.inventoryFace;
    }

    public static class Factory
    implements Callable<IConnectableItemAutoIO> {
        @Override
        public IConnectableItemAutoIO call() throws Exception {
            return new CapabilityConnectableAutoIO(EnumStorageDirection.IN);
        }
    }
}

