/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.NetworkCraftingInventory;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.NetworkDirection;

public abstract class ContainerNetwork
extends AbstractContainerMenu {
    protected final ResultContainer resultInventory = new ResultContainer();
    protected Inventory playerInv;
    protected ResultSlot result;
    protected boolean recipeLocked = false;
    protected Player player;
    protected Level world;
    protected CraftingRecipe recipeCurrent;
    public NetworkCraftingInventory matrix;

    public abstract TileMain getTileMain();

    public abstract void slotChanged();

    protected ContainerNetwork(MenuType<?> type, int id) {
        super(type, id);
    }

    public CraftingContainer getCraftMatrix() {
        return this.matrix;
    }

    protected void bindPlayerInvo(Inventory playerInv) {
        this.player = playerInv.f_35978_;
        this.world = this.player.f_19853_;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 174 + i * 18));
            }
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (!this.isCrafting()) {
            return super.m_5882_(stack, slot);
        }
        return slot.f_40218_ != this.result && super.m_5882_(stack, slot);
    }

    public void bindHotbar() {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInv, i, 8 + i * 18, 232));
        }
    }

    protected void bindGrid() {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.matrix, index++, 8 + j * 18, 110 + i * 18));
            }
        }
    }

    public void m_6877_(Player playerIn) {
        this.slotChanged();
        super.m_6877_(playerIn);
    }

    public void m_6199_(Container inventoryIn) {
        if (this.recipeLocked) {
            return;
        }
        super.m_6199_(inventoryIn);
        this.recipeCurrent = null;
        this.findMatchingRecipe(this.f_38840_, this.world, this.player, this.matrix, this.resultInventory);
    }

    protected void findMatchingRecipeClient(Level world, CraftingContainer inventory, ResultContainer result) {
        Optional optional = world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)inventory, world);
        if (optional.isPresent()) {
            CraftingRecipe icraftingrecipe;
            this.recipeCurrent = icraftingrecipe = (CraftingRecipe)optional.get();
        }
    }

    private void findMatchingRecipe(int containerId, Level world, Player player, CraftingContainer inventory, ResultContainer result) {
        if (!world.f_46443_) {
            CraftingRecipe icraftingrecipe;
            boolean slotId = false;
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = world.m_142572_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)inventory, world);
            if (optional.isPresent() && result.m_40135_(world, serverplayerentity, (Recipe)(icraftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.m_5874_((Container)inventory);
                this.recipeCurrent = icraftingrecipe;
            }
            result.m_6836_(0, itemstack);
            serverplayerentity.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(containerId, this.m_182425_(), 0, itemstack));
        }
    }

    public abstract boolean isCrafting();

    public ItemStack m_7648_(Player playerIn, int slotIndex) {
        if (playerIn.f_19853_.f_46443_) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            TileMain tileMain = this.getTileMain();
            if (this.isCrafting() && slotIndex == 0) {
                this.craftShift(playerIn, tileMain);
                return ItemStack.f_41583_;
            }
            if (tileMain != null) {
                int rest = tileMain.insertStack(itemstack1, false);
                ItemStack stack = rest == 0 ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)rest);
                slot.m_5852_(stack);
                this.m_38946_();
                List<ItemStack> list = tileMain.getSortedStacks();
                if (playerIn instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)playerIn;
                    PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), sp.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                }
                if (stack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(playerIn, itemstack1);
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected void craftShift(Player player, TileMain tile) {
        if (!this.isCrafting() || this.matrix == null || tile == null) {
            return;
        }
        this.recipeCurrent = null;
        this.findMatchingRecipeClient(player.f_19853_, this.matrix, this.resultInventory);
        if (this.recipeCurrent == null) {
            return;
        }
        this.recipeLocked = true;
        int crafted = 0;
        ArrayList recipeCopy = Lists.newArrayList();
        for (int i = 0; i < this.matrix.m_6643_(); ++i) {
            recipeCopy.add(this.matrix.m_8020_(i).m_41777_());
        }
        ItemStack res = this.recipeCurrent.m_5874_((Container)this.matrix);
        if (res.m_41619_()) {
            StorageNetwork.LOGGER.error("err Recipe output is an empty stack " + this.recipeCurrent);
            return;
        }
        int sizePerCraft = res.m_41613_();
        while (crafted + sizePerCraft <= res.m_41741_() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInv), (ItemStack)(res = this.recipeCurrent.m_5874_((Container)this.matrix)), (boolean)true).m_41619_() && this.recipeCurrent.m_5818_((Container)this.matrix, player.f_19853_)) {
            if (!player.m_150109_().m_36054_(res)) {
                player.m_36176_(res, false);
            }
            NonNullList remainder = this.recipeCurrent.m_7457_((Container)this.matrix);
            for (int i = 0; i < remainder.size(); ++i) {
                ItemStack remainderCurrent = (ItemStack)remainder.get(i);
                ItemStack slot = this.matrix.m_8020_(i);
                if (remainderCurrent.m_41619_()) {
                    this.matrix.m_8020_(i).m_41774_(1);
                    continue;
                }
                if (slot.m_41720_().m_41469_() != null) {
                    slot = new ItemStack((ItemLike)slot.m_41720_().m_41469_());
                    this.matrix.m_6836_(i, slot);
                    continue;
                }
                if (!slot.m_41720_().getContainerItem(slot).m_41619_()) {
                    slot = slot.m_41720_().getContainerItem(slot);
                    this.matrix.m_6836_(i, slot);
                    continue;
                }
                if (!remainderCurrent.m_41619_()) {
                    if (slot.m_41619_()) {
                        this.matrix.m_6836_(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.m_41746_((ItemStack)slot, (ItemStack)remainderCurrent) && ItemStack.m_41658_((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        remainderCurrent.m_41769_(slot.m_41613_());
                        this.matrix.m_6836_(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.m_41758_((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        this.matrix.m_6836_(i, remainderCurrent);
                        continue;
                    }
                    if (player.m_150109_().m_36054_(remainderCurrent)) continue;
                    player.m_36176_(remainderCurrent, false);
                    continue;
                }
                if (slot.m_41619_()) continue;
                this.matrix.m_7407_(i, 1);
                slot = this.matrix.m_8020_(i);
            }
            crafted += sizePerCraft;
            for (int i = 0; i < this.matrix.m_6643_(); ++i) {
                ItemStack stackInSlot = this.matrix.m_8020_(i);
                if (!stackInSlot.m_41619_()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackMatcher itemStackMatcherCurrent = !recipeStack.m_41619_() ? new ItemStackMatcher(recipeStack, false, false) : null;
                ItemStack req = tile.request(itemStackMatcherCurrent, 1, false);
                this.matrix.m_6836_(i, req);
            }
            this.m_6199_((Container)this.matrix);
        }
        this.m_38946_();
        this.recipeLocked = false;
        this.m_6199_((Container)this.matrix);
    }
}

