/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.main;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.BaseBlock;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class BlockMain
extends BaseBlock {
    public BlockMain() {
        super(Material.f_76279_, "master");
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        this.updateConnection(worldIn, pos, state);
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tileAtPos = worldIn.m_7702_(pos);
        if (tileAtPos != null) {
            ((TileMain)tileAtPos).refreshNetwork();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult result) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileHere = worldIn.m_7702_(pos);
        if (!(tileHere instanceof TileMain)) {
            return InteractionResult.PASS;
        }
        if (hand == InteractionHand.MAIN_HAND && playerIn.m_21120_(hand).m_41619_()) {
            this.displayConnections(playerIn, tileHere);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void displayConnections(Player playerIn, BlockEntity tileHere) {
        TileMain tileMain = (TileMain)tileHere;
        int total = tileMain.getConnectablePositions().size();
        if (total == 0) {
            return;
        }
        playerIn.m_6352_((Component)new TranslatableComponent(ChatFormatting.LIGHT_PURPLE + UtilTileEntity.lang("chat.main.emptyslots") + tileMain.emptySlots()), playerIn.m_142081_());
        playerIn.m_6352_((Component)new TranslatableComponent(ChatFormatting.DARK_AQUA + UtilTileEntity.lang("chat.main.connectables") + total), playerIn.m_142081_());
        HashMap<String, Integer> mapNamesToCount = new HashMap<String, Integer>();
        for (DimPos p : tileMain.getConnectablePositions()) {
            Block bl = p.getBlockState().m_60734_();
            String blockName = new TranslatableComponent(bl.m_7705_()).getString();
            int count = mapNamesToCount.get(blockName) != null ? (Integer)mapNamesToCount.get(blockName) + 1 : 1;
            mapNamesToCount.put(blockName, count);
        }
        ArrayList listDisplayStrings = Lists.newArrayList();
        for (Map.Entry e : mapNamesToCount.entrySet()) {
            listDisplayStrings.add(e);
        }
        Collections.sort(listDisplayStrings, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return Integer.compare(o2.getValue(), o1.getValue());
            }
        });
        for (Map.Entry e : listDisplayStrings) {
            playerIn.m_6352_((Component)new TranslatableComponent(ChatFormatting.AQUA + "    " + e.getValue() + ": " + (String)e.getKey()), playerIn.m_142081_());
        }
    }

    public RenderShape m_7514_(BlockState bs) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockMain.m_152132_(type, SsnRegistry.MAINTILEENTITY, (BlockEntityTicker)(world.f_46443_ ? TileMain::clientTick : TileMain::serverTick));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMain(pos, state);
    }
}

