/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.util.UtilInventory;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import org.apache.commons.lang3.tuple.Triple;

public class ItemCollector
extends Item {
    public static final String NBT_BOUND = "bound";

    public ItemCollector(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    protected ItemStack findAmmo(Player player, Item item) {
        Triple<String, Integer, ItemStack> remote = UtilInventory.getCurioRemote(player, item);
        return (ItemStack)remote.getRight();
    }

    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof Player && event.getItem() != null && !event.getItem().m_32055_().m_41619_()) {
            ItemStack item = event.getItem().m_32055_();
            Player player = (Player)event.getEntityLiving();
            Level world = player.f_19853_;
            DimPos dp = DimPos.getPosStored(this.findAmmo(player, this));
            if (dp != null && !world.f_46443_) {
                ServerLevel serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.m_142572_());
                if (serverTargetWorld == null) {
                    StorageNetwork.LOGGER.error("Missing dimension key " + dp.getDimension());
                    return;
                }
                BlockEntity tile = serverTargetWorld.m_7702_(dp.getBlockPos());
                if (tile instanceof TileMain) {
                    TileMain network = (TileMain)tile;
                    int countUnmoved = network.insertStack(item.m_41777_(), false);
                    item.m_41764_(countUnmoved);
                    if (countUnmoved == 0) {
                        UtilTileEntity.playSoundFromServer((ServerPlayer)player, SoundEvents.f_12019_, 0.2f);
                    }
                } else {
                    StorageNetwork.LOGGER.error("item.remote.notfound");
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world.m_7702_(pos) instanceof TileMain) {
            ItemStack stack = player.m_21120_(hand);
            DimPos.putPos(stack, pos, world);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        DimPos dp;
        TranslatableComponent t = new TranslatableComponent(this.m_5524_() + ".tooltip");
        t.m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)t);
        if (stack.m_41782_() && (dp = DimPos.getPosStored(stack)) != null) {
            tooltip.add(dp.makeTooltip());
        }
    }
}

