/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item.remote;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.IGuiNetwork;
import com.lothrazar.storagenetwork.gui.NetworkWidget;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.item.remote.ItemStorageCraftingRemote;
import com.lothrazar.storagenetwork.jei.JeiHooks;
import com.lothrazar.storagenetwork.network.SettingsSyncMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class GuiNetworkRemote
extends AbstractContainerScreen<ContainerNetworkRemote>
implements IGuiNetwork {
    private static final int HEIGHT = 256;
    private static final int WIDTH = 176;
    private static final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/inventory.png");
    private final NetworkWidget network;
    private final ItemStack remote;

    public GuiNetworkRemote(ContainerNetworkRemote screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.remote = inv.f_35978_.m_21120_(InteractionHand.MAIN_HAND);
        this.network = new NetworkWidget(this);
        this.network.setLines(8);
        this.f_97726_ = 176;
        this.f_97727_ = 256;
        this.network.fieldHeight = 180;
    }

    @Override
    public void renderStackTooltip(PoseStack ms, ItemStack stack, int mousex, int mousey) {
        super.m_6057_(ms, stack, mousex, mousey);
    }

    @Override
    public void setStacks(List<ItemStack> stacks) {
        this.network.stacks = stacks;
    }

    @Override
    public boolean getDownwards() {
        return ItemStorageCraftingRemote.getDownwards(this.remote);
    }

    @Override
    public void setDownwards(boolean val) {
        ItemStorageCraftingRemote.setDownwards(this.remote, val);
    }

    @Override
    public EnumSortType getSort() {
        return ItemStorageCraftingRemote.getSort(this.remote);
    }

    @Override
    public void setSort(EnumSortType val) {
        ItemStorageCraftingRemote.setSort(this.remote, val);
    }

    @Override
    public boolean isJeiSearchSynced() {
        return ItemStorageCraftingRemote.isJeiSearchSynced(this.remote);
    }

    @Override
    public void setJeiSearchSynced(boolean val) {
        ItemStorageCraftingRemote.setJeiSearchSynced(this.remote, val);
    }

    public void m_7856_() {
        super.m_7856_();
        int searchLeft = this.f_97735_ + 81;
        int searchTop = this.f_97736_ + 160;
        int width = 85;
        Objects.requireNonNull(this.f_96547_);
        this.network.searchBar = new EditBox(this.f_96547_, searchLeft, searchTop, width, 9, null);
        this.network.searchBar.m_94199_(30);
        this.network.initSearchbar();
        this.network.initButtons();
        this.m_142416_((GuiEventListener)this.network.directionBtn);
        this.m_142416_((GuiEventListener)this.network.sortBtn);
        if (ModList.get().isLoaded("jei")) {
            this.m_142416_((GuiEventListener)this.network.jeiBtn);
        }
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ms);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.m_7025_(ms, mouseX, mouseY);
        this.network.searchBar.m_6305_(ms, mouseX, mouseY, partialTicks);
        this.network.render();
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(ms, k, l, 0, 0, this.f_97726_, this.f_97727_);
        this.network.applySearchTextToSlots();
        this.network.renderItemSlots(ms, mouseX, mouseY, this.f_96547_);
    }

    public void m_7027_(PoseStack ms, int mouseX, int mouseY) {
        this.network.drawGuiContainerForegroundLayer(ms, mouseX, mouseY, this.f_96547_);
    }

    boolean isScrollable(double x, double y) {
        int scrollHeight = 152;
        return this.m_6774_(0, 0, this.f_96543_ - 8, scrollHeight, x, y);
    }

    public boolean m_6050_(double x, double y, double mouseButton) {
        super.m_6050_(x, y, mouseButton);
        if (this.isScrollable(x, y) && mouseButton != 0.0) {
            this.network.mouseScrolled(mouseButton);
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        super.m_6375_(mouseX, mouseY, mouseButton);
        this.network.mouseClicked(mouseX, mouseY, mouseButton);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int b) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        if (this.network.searchBar.m_93696_()) {
            if (keyCode == 259) {
                this.network.syncTextToJei();
            }
            this.network.searchBar.m_7933_(keyCode, scanCode, b);
            return true;
        }
        if (this.network.stackUnderMouse.m_41619_()) {
            try {
                JeiHooks.testJeiKeybind(mouseKey, this.network.stackUnderMouse);
            }
            catch (Throwable e) {
                StorageNetwork.LOGGER.error("JEI compat issue ", e);
            }
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, b);
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        return this.network.charTyped(typedChar, keyCode);
    }

    @Override
    public void drawGradient(PoseStack ms, int x, int y, int x2, int y2, int u, int v) {
        super.m_93179_(ms, x, y, x2, y2, u, v);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.m_6774_(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public void syncDataToServer() {
        PacketRegistry.INSTANCE.sendToServer((Object)new SettingsSyncMessage(null, this.getDownwards(), this.getSort(), this.isJeiSearchSynced()));
    }
}

