/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.jei;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import net.minecraft.client.KeyMapping;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class JeiHooks {
    private static boolean isJeiLoaded() {
        return ModList.get().isLoaded("jei");
    }

    public static String getFilterText() {
        try {
            if (JeiHooks.isJeiLoaded()) {
                return JeiHooks.getJeiTextInternal();
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.info(" mezz.jei.Internal not found " + e);
        }
        return "";
    }

    public static void setFilterText(String s) {
        try {
            if (JeiHooks.isJeiLoaded()) {
                JeiHooks.setJeiTextInternal(s);
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.info(" mezz.jei.Internal not found " + e);
        }
    }

    private static void setJeiTextInternal(String s) {
        Internal.getRuntime().getIngredientFilter().setFilterText(s);
    }

    private static String getJeiTextInternal() {
        return Internal.getRuntime().getIngredientFilter().getFilterText();
    }

    public static void testJeiKeybind(InputConstants.Key keyCode, ItemStack stackUnderMouse) {
        boolean showUses;
        if (!JeiHooks.isJeiLoaded()) {
            return;
        }
        boolean showRecipe = ((KeyMapping)KeyBindings.showRecipe.get(0)).isActiveAndMatches(keyCode) || ((KeyMapping)KeyBindings.showRecipe.get(1)).isActiveAndMatches(keyCode);
        boolean bl = showUses = ((KeyMapping)KeyBindings.showUses.get(0)).isActiveAndMatches(keyCode) || ((KeyMapping)KeyBindings.showUses.get(1)).isActiveAndMatches(keyCode);
        if (showRecipe || showUses) {
            IFocus.Mode mode = showRecipe ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT;
            Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(mode, (Object)stackUnderMouse));
        }
    }
}

