/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.collection;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.capability.handler.ItemStackHandlerEx;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class CollectionItemStackHandler
extends ItemStackHandlerEx {
    private TileMain tileMain;
    TileConnectable tile;

    public CollectionItemStackHandler() {
        super(1);
        this.update();
    }

    public void setMain(TileMain main) {
        this.tileMain = main;
        this.update();
    }

    public void update() {
        this.stacks.clear();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_() || this.tileMain == null || !this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        IConnectable cap = (IConnectable)this.tile.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY).orElse(null);
        FilterItemStackHandler filter = cap.getFilter();
        if (filter != null && !filter.allAreEmpty() && filter.isStackFiltered(stack)) {
            return stack;
        }
        try {
            int remaining = this.tileMain.insertStack(stack, simulate);
            if (remaining > 0) {
                this.update();
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)remaining);
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("insertStack error ", (Throwable)e);
        }
        this.update();
        return ItemStack.f_41583_;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }
}

