/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky;

import de.dafuqs.starrysky.advancements.ProximityAdvancementCheckEvent;
import de.dafuqs.starrysky.commands.StarrySkyCommands;
import de.dafuqs.starrysky.configs.StarrySkyConfig;
import de.dafuqs.starrysky.dimension.DecoratorFeatures;
import de.dafuqs.starrysky.dimension.StarrySkyDimension;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarrySkyCommon
implements ModInitializer {
    public static final String MOD_ID = "starry_sky";
    public static StarrySkyConfig STARRY_SKY_CONFIG;
    private static final Logger LOGGER;
    public static class_3218 starryWorld;
    public static class_3218 starryWorldNether;
    public static class_3218 starryWorldEnd;

    public void onInitialize() {
        StarrySkyCommon.log(Level.INFO, "Starting up...");
        AutoConfig.register(StarrySkyConfig.class, JanksonConfigSerializer::new);
        STARRY_SKY_CONFIG = (StarrySkyConfig)AutoConfig.getConfigHolder(StarrySkyConfig.class).getConfig();
        StarrySkyDimension.setupDimension();
        StarrySkyDimension.setupPortals();
        StarrySkyCommands.initialize();
        DecoratorFeatures.initialize();
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983().equals(StarrySkyDimension.STARRY_SKY_WORLD_KEY)) {
                starryWorld = world;
            } else if (world.method_27983().equals(StarrySkyDimension.STARRY_SKY_NETHER_WORLD_KEY)) {
                starryWorldNether = world;
            } else if (world.method_27983().equals(StarrySkyDimension.STARRY_SKY_END_WORLD_KEY)) {
                starryWorldEnd = world;
            }
        });
        ServerTickEvents.END_SERVER_TICK.register((Object)new ProximityAdvancementCheckEvent());
        StarrySkyCommon.log(Level.INFO, "Finished loading.");
    }

    public static void log(Level logLevel, String message) {
        LOGGER.log(logLevel, "[StarrySkies] " + message);
    }

    public static boolean inStarryWorld(class_3222 serverPlayerEntity) {
        class_5321 worldRegistryKey = serverPlayerEntity.method_5770().method_27983();
        return StarrySkyCommon.isStarryWorld((class_5321<class_1937>)worldRegistryKey);
    }

    public static boolean isStarryWorld(class_5321<class_1937> worldRegistryKey) {
        if (starryWorld == null && starryWorldNether == null && starryWorldEnd == null) {
            StarrySkyCommon.log(Level.ERROR, "The Starry Dimensions could not be loaded. If this is your first launch this is probably related to a known vanilla bug where custom dimensions are not loaded when first generating the world. Restarting / quitting and reloading will fix this issue.");
            return false;
        }
        return worldRegistryKey.equals((Object)starryWorld.method_27983()) || worldRegistryKey.equals((Object)starryWorldNether.method_27983()) || worldRegistryKey.equals((Object)starryWorldEnd.method_27983());
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
    }
}

